#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QDebug>
#include <QMessageBox>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    ui->statusBar->showMessage("DaqmxBase Initialize...");
    ui->pushButton_Output->setEnabled(false);
    ui->pushButton_Output->setText("ON");

    ui->doubleSpinBox_Freq->setValue(1000.0);
    ui->dial_Freq->setValue(1000);

    ui->doubleSpinBox_Duty->setValue(50.0);
    ui->horizontalSlider_Duty->setValue(50);

    flag_output_status = false;

    // Init & Start DAQ Thread
    DaqTh = new DAQThread(this);
    // connect signals
    connect(DaqTh, SIGNAL(daqmxbase_ready()),
                this, SLOT(daqmxbase_ready()));
    connect(DaqTh, SIGNAL(daqmxbase_final()),
                this, SLOT(daqmxbase_final()));
    connect(DaqTh, SIGNAL(daqmxbase_error(QString)),
                this, SLOT(daqmxbase_error(QString)));
    connect(DaqTh, SIGNAL(pulse_output_started()),
                this, SLOT(pulse_output_started()));
    connect(DaqTh, SIGNAL(pulse_output_stopped()),
            this, SLOT(pulse_output_stopped()));
            // DaqTh start
    DaqTh->start();
}

MainWindow::~MainWindow()
{
    // Final DaqTh
    DaqTh->stop();
    DaqTh->wait();
    delete DaqTh;

    delete ui;
}

void MainWindow::on_pushButton_Output_clicked()
{
    if (flag_output_status) {
        DaqTh->stopPulseOutput();
        ui->pushButton_Output->setText("ON");
        flag_output_status = false;
    } else {
        DaqTh->startPulseOutput((float)ui->doubleSpinBox_Freq->value(), (float)ui->doubleSpinBox_Duty->value());
        ui->pushButton_Output->setText("OFF");
        flag_output_status = true;
    }
}

void MainWindow::on_doubleSpinBox_Freq_valueChanged(double arg1)
{
    ui->dial_Freq->setValue((int)arg1);

    DaqTh->changePulseOutput((float)ui->doubleSpinBox_Freq->value(), (float)ui->doubleSpinBox_Duty->value());
}

void MainWindow::on_dial_Freq_valueChanged(int value)
{
    ui->doubleSpinBox_Freq->setValue((double)value);
}

void MainWindow::on_doubleSpinBox_Duty_valueChanged(double arg1)
{
    ui->horizontalSlider_Duty->setValue((int)arg1);

    DaqTh->changePulseOutput((float)ui->doubleSpinBox_Freq->value(), (float)ui->doubleSpinBox_Duty->value());
}

void MainWindow::on_horizontalSlider_Duty_valueChanged(int value)
{
    ui->doubleSpinBox_Duty->setValue((double)value);
}

void MainWindow::daqmxbase_ready()
{
    ui->statusBar->showMessage("Idle...");
    ui->pushButton_Output->setEnabled(true);
}

void MainWindow::daqmxbase_final()
{
    ui->pushButton_Output->setEnabled(false);
    ui->statusBar->showMessage("DaqmxBase final.");
}

void MainWindow::daqmxbase_error(QString ErrMsg)
{
    // Dialog
    QMessageBox::critical(this, "DaqmxBase Error", ErrMsg);
}

void MainWindow::pulse_output_started()
{
    ui->statusBar->showMessage("Output pulse.");
}

void MainWindow::pulse_output_stopped()
{
    ui->statusBar->showMessage("Idle...");
}


