#include "registholiday_dialog.h"
#include "ui_registholiday_dialog.h"

#include <QDebug>

RegistHoliday_Dialog::RegistHoliday_Dialog(QStringList &list, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::RegistHoliday_Dialog)
{
    ui->setupUi(this);

    ui->listWidget_HolidaysList->clear();
    ui->listWidget_HolidaysList->addItems(list);

    // Set ListWidget, and spinBox hh:mm
    ui->listWidget_HolidaysList->setCurrentRow(0);
    QStringList current_data = ui->listWidget_HolidaysList->currentItem()->text().split("/");
    ui->spinBox_Month->setValue(current_data.at(0).toInt());
    ui->spinBox_Day->setValue(current_data.at(1).toInt());
}

RegistHoliday_Dialog::~RegistHoliday_Dialog()
{
    delete ui;
}

QStringList RegistHoliday_Dialog::HolidaysList()
{
    QStringList list;
    for (int i = 0; i < ui->listWidget_HolidaysList->count(); i++) {
        list << ui->listWidget_HolidaysList->item(i)->text();
    }
    return list;
}

void RegistHoliday_Dialog::on_listWidget_HolidaysList_currentRowChanged(int currentRow)
{
    QStringList current_data = ui->listWidget_HolidaysList->currentItem()->text().split("/");
    ui->spinBox_Month->setValue(current_data.at(0).toInt());
    ui->spinBox_Day->setValue(current_data.at(1).toInt());
}

void RegistHoliday_Dialog::on_pushButton_Change_clicked()
{
    int mon = ui->spinBox_Month->value();
    int day = ui->spinBox_Day->value();
    QString datestr = QString("%1/%2").arg(mon,2,10,QChar('0')).arg(day,2,10,QChar('0'));

    QList<QListWidgetItem*> findresult = ui->listWidget_HolidaysList->findItems(datestr, Qt::MatchExactly);
    if (findresult.isEmpty()) {
        // change item when not exist of SchTimeList
        QListWidgetItem *item = ui->listWidget_HolidaysList->currentItem();
        item->setText(datestr);
        ui->listWidget_HolidaysList->setCurrentItem(item);
    } else {
        ;
    }
}

void RegistHoliday_Dialog::on_pushButton_Add_clicked()
{
    int mon = ui->spinBox_Month->value();
    int day = ui->spinBox_Day->value();
    QString datestr = QString("%1/%2").arg(mon,2,10,QChar('0')).arg(day,2,10,QChar('0'));

    QList<QListWidgetItem*> findresult = ui->listWidget_HolidaysList->findItems(datestr, Qt::MatchExactly);
    if (findresult.isEmpty()) {
        // change item when not exist of SchTimeList
        QListWidgetItem *item = new QListWidgetItem();
        item->setText(datestr);
        ui->listWidget_HolidaysList->insertItem(ui->listWidget_HolidaysList->currentRow(), item);
    } else {
        ;
    }
}

void RegistHoliday_Dialog::on_pushButton_Del_clicked()
{
    // one of the last?
    if (1 >= ui->listWidget_HolidaysList->count()) return;

    // delete currentRow item
    ui->listWidget_HolidaysList->takeItem(ui->listWidget_HolidaysList->currentRow());

}
