#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QLabel>
#include <QTimer>

#include "thschmanager.h"
#include "PlayMusicThread.h"

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
    
public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();
    
private slots:
    void TimeoutDone();
    void slot_notify_nexttime(QString nexttime);

    void on_actionExit_triggered();

    void on_actionAbout_triggered();

    void on_actionAbout_Qt_triggered();

    void on_toolButton_FileSelect_clicked();

    void on_pushButton_clicked();

    void on_pushButton_TestPlay_clicked();

    void on_listWidget_SchTimeList_currentRowChanged(int currentRow);

    void on_pushButton_Change_clicked();

    void on_pushButton_Add_clicked();

    void on_pushButton_Del_clicked();

    void on_pushButton_RegistHoliday_clicked();

    void on_lineEdit_FilePath_textChanged(const QString &arg1);

    void on_hSlider_Volume_valueChanged(int value);

private:
    Ui::MainWindow *ui;
    QLabel *statusbar_label_status;
    QLabel *statusbar_label_nowtime;
    QTimer *Timer1sec;
    int status; // 0 = idle, 1 = Exec SchChime

    void LoadSaveSetting(QString filepath, bool store);
    QString IniFilePath;

    QString DefaultChimeFilePath;

    ThSchManager    *ThSchMngr;
    PlayMusicThread *ThPlayMusic;

    QStringList Holidays;
};

#endif // MAINWINDOW_H
