
#include <QFileInfo>
#include <QCloseEvent>

#include "sendfile_dialog.h"
#include "ui_sendfile_dialog.h"

SendFile_Dialog::SendFile_Dialog(QWidget *parent, QString path) :
    QDialog(parent),
    ui(new Ui::SendFile_Dialog)
{
    ui->setupUi(this);

    connect(ui->pushButtonCancel, SIGNAL(clicked()), this, SIGNAL(stopSendFile()));

    this->filepath = path;
    QFileInfo fi(this->filepath);
    ui->lineEditFileName->setText(fi.fileName());
    ui->label_3->setText(QString(tr("FileSize: %1 bytes")).arg(fi.size()));
    ui->progressBar->setValue(0);
}

SendFile_Dialog::~SendFile_Dialog()
{
    delete ui;
}

void SendFile_Dialog::closeEvent(QCloseEvent* e){
    e->ignore(); // ignore window title bar close button
}

void SendFile_Dialog::updateProgressbar(int progress)
{
    ui->progressBar->setValue(progress);
}
