package jp.coocan.la.aide.android.snapcard;

import java.util.List;

import android.app.Activity;
import android.content.Intent;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.net.Uri;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;


public class MainActivity extends Activity implements SensorEventListener {

	private final int REQUEST_GALLERY = 1;
	
	
    private MainView mainView;
    private SensorManager sensorManager = null;
    private boolean isRegiseredSensor = false;
    
    private float oldAccelerometerValue = 0.0f;
    
	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        
        setContentView(R.layout.main);
        
        initializeApplicationContainer();
        
        //ZT[
        sensorManager = (SensorManager)getSystemService(SENSOR_SERVICE);
        
        //ʕ\
        mainView = new MainView(this);
        setContentView(mainView);
    }
    
    
    @Override
	public boolean onCreateOptionsMenu(Menu menu) {
		super.onCreateOptionsMenu( menu );
		
	    this.getMenuInflater().inflate( R.menu.main, menu );
	    
	    return true;
	}

    
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		super.onOptionsItemSelected(item);
		
		switch(item.getItemId()){
		
		case R.id.menu_gallery : {
			startSelectCardImage();
		    return true;
		}
		
		}
		
		return false;
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
		super.onActivityResult( requestCode, resultCode, intent );
		
		if (resultCode != RESULT_OK) return;
		
		switch( requestCode ){
		
		case REQUEST_GALLERY :{
			completeSelectCardImage( intent );
		}
		
		}
	}

	
	@Override
    protected void onResume() {
        super.onResume();
        
        //xZT[̃Xi[o^
        List<Sensor> sensors = sensorManager.getSensorList(Sensor.TYPE_ACCELEROMETER);
        if (sensors.size() > 0) {
            Sensor sensor = sensors.get(0);
            isRegiseredSensor = sensorManager.registerListener(
            		this,
            		sensor,
            		SensorManager.SENSOR_DELAY_UI
            	);
        }
    }

    @Override
    protected void onPause() {
    	//xZT[̃Xi[o^
        if (isRegiseredSensor) {
        	sensorManager.unregisterListener( this );
        	isRegiseredSensor = false;
        }
        
        super.onPause();
    }


	public void onAccuracyChanged(Sensor sensor, int accuracy) {
		
	}


	public void onSensorChanged(SensorEvent event) {
		
		if( event.sensor.getType() == Sensor.TYPE_ACCELEROMETER ){
			if( event.values[1] - oldAccelerometerValue >= 2.5f ){
				mainView.startSnapIn();
			}
			
			oldAccelerometerValue = event.values[1];
		}
	}

	
    public void initializeApplicationContainer(){
    	
    	//DisplayMetrics
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics( displayMetrics );
        ApplicationContainer.setDisplayMetrics( displayMetrics );
        
        //ContentResolver
        ApplicationContainer.setContentResolver( getContentResolver() );
    }
    
    public void startSelectCardImage(){
		Intent intent = new Intent();
		intent.setType( "image/*" );
		intent.setAction( Intent.ACTION_PICK );
		intent.addCategory(Intent.CATEGORY_DEFAULT);
		startActivityForResult( intent, REQUEST_GALLERY );
    }

    public void completeSelectCardImage(Intent intent){
		Uri uri= intent.getData();
		
		mainView.loadCardBitmap( uri );
    }
    
    
}