package jp.coocan.la.aide.android.snapcard;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Paint.Style;
import android.net.Uri;
import android.os.Environment;
import android.provider.MediaStore;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;


public class MainView extends View {

    private Paint  paint;

    private Bitmap cardBitmap;
    private Bitmap [] snapInBitmap = new Bitmap[5];
    
    private float offsetX = 0f;
    private float offsetY = 0f;
    
    private float dragX = 0f;
    private float dragY = 0f;

    private float rangeX = 0f;
    private float rangeY = 0f;
    
    private final int CARDSTATUS_TAPABLE   = 0;
    private final int CARDSTATUS_SNAPOUT   = 1;
    private final int CARDSTATUS_INVISIBLE = 2;
    private final int CARDSTATUS_SNAPIN    = 3;
    private int cardStatus = CARDSTATUS_TAPABLE;
    	
    private float snapOutSteps =  50.0f;
    private float snapInSteps  = 200.0f;
    private int snapInCount = 0;
    
	public MainView(Context context) {
		super(context);
		
		paint = new Paint();
    	paint.setAntiAlias( true );
    	paint.setColor( Color.BLACK );
    	paint.setStyle( Style.FILL );
		
    	//h摜[h
		File strageDirname = Environment.getExternalStorageDirectory();
		String imageFilename = strageDirname + "/SnapCard/card.jpg";
		Uri uri = Uri.fromFile( new File( imageFilename ) );
        loadCardBitmap( uri );
        
        //ʃTCYsnap܂ł̃tbN̋Zo
		DisplayMetrics displayMetrics = ApplicationContainer.getDisplayMetrics();
        rangeX = (float)displayMetrics.widthPixels  / 3.0f;
        rangeY = (float)displayMetrics.heightPixels / 3.0f;
        
        //Snap̈ړxZo
        snapOutSteps = 50.0f;
        snapInSteps = (float)cardBitmap.getHeight() / 5.0f; 
	}
	
	public void loadCardBitmap( Uri uri ){
		
		DisplayMetrics displayMetrics = ApplicationContainer.getDisplayMetrics();
		Bitmap src = null;

		//݂̖h摜
		if( cardBitmap != null ){
			cardBitmap.recycle();
			cardBitmap = null;
		}
		for( int i = 0; i < 5; i ++ ){
			if( snapInBitmap[i] != null ){
				snapInBitmap[i].recycle();
				snapInBitmap[i] = null;
			}
		}
		
        //DPIʏ̖h̃sNZTCYZo
        float cardPixelWidth  = displayMetrics.xdpi * displayMetrics.scaledDensity * 2.17f;
        float cardPixelHeight = displayMetrics.ydpi * displayMetrics.scaledDensity * 3.56f;
        
		//URIh摜擾
		if( uri != null ){
			try{
				BitmapFactory.Options opts = new BitmapFactory.Options();
				InputStream is;
				
				opts.inJustDecodeBounds = true;
				is = ApplicationContainer.getContentResolver().openInputStream( uri );
				try{
					BitmapFactory.decodeStream( is, null, opts );					
				}finally{
					is.close();
				}
				
		        //h̃sNZTCYBitmapTCYXP[vZ
				int scaleX = (int)Math.floor( (double)opts.outWidth  / (double)cardPixelWidth );
				int scaleY = (int)Math.floor( (double)opts.outHeight / (double)cardPixelHeight );
				
				opts.inJustDecodeBounds = false;
				opts.inSampleSize = Math.min( scaleX, scaleY );
				
				is = ApplicationContainer.getContentResolver().openInputStream( uri );
				try{
					src = BitmapFactory.decodeStream( is, null, opts );					
				}finally{
					is.close();
				}
				
			}catch(IOException e){
				src = null;
			}
		}
		
		//URI擾łȂꍇ̓\[X擾
		if( src == null ){
			//\[X摜擾
			src = BitmapFactory.decodeResource(
				getResources(), 
				R.drawable.dftcard
			);
		}
		
        //h̃sNZTCYBitmapTCYXP[vZ
		float scaleX = (float)cardPixelWidth  / (float)src.getWidth();
		float scaleY = (float)cardPixelHeight / (float)src.getHeight();

        //h摜쐬
		cardBitmap = Bitmap.createScaledBitmap(
				src, 
				(int)((float)src.getWidth()  * scaleX),
				(int)((float)src.getHeight() * scaleY),
				true
			);
		int srcWidth  = cardBitmap.getWidth();
		int srcHeight = cardBitmap.getHeight();
		
		src.recycle();
		src = null;
		
		//SnapInp̉]摜𐶐
		Matrix matrix = new Matrix();
		for( int i = 0; i < 5; i ++ ){
			matrix.setRotate( 
					90.0f / 5.0f * (float)(5 - i)
				);
			snapInBitmap[i] = Bitmap.createBitmap(
					cardBitmap, 
					0, 
					0, 
					srcWidth, 
					srcHeight, 
					matrix, 
					true
				);
		}
	}
	
    @Override
    protected void onDraw(Canvas canvas) {
    	//canvas̃J[
    	canvas.drawColor(Color.BLACK);

    	switch( cardStatus ){
    	
    	case CARDSTATUS_SNAPOUT : {
			dragX += snapOutSteps;
    		float x = (canvas.getWidth()  - cardBitmap.getWidth() ) / 2 + (dragX - offsetX);
    		float y = (canvas.getHeight() - cardBitmap.getHeight()) / 2 + (dragY - offsetY);
	    	canvas.drawBitmap( cardBitmap, x, y, paint );
	    	
			if( x > canvas.getWidth() ) {  
				cardStatus = CARDSTATUS_INVISIBLE; 
			}
	        invalidate();
			break;
    	}
    	
    	case CARDSTATUS_SNAPIN : {
			dragY += snapInSteps;
    		float x = (canvas.getWidth()  - cardBitmap.getWidth() ) / 2 + (dragX - offsetX);
    		float y = (canvas.getHeight() - cardBitmap.getHeight()) / 2 + (dragY - offsetY);
	    	canvas.drawBitmap( snapInBitmap[snapInCount], x, y, paint );
	    	
	    	snapInCount ++;
	    	if( snapInCount > 5 ) { snapInCount = 0; }
	    	
			if( y >= 0 ) { 
				resetPosition(); 
				cardStatus = CARDSTATUS_TAPABLE;
			}
	        invalidate();
			break;
    	}
			
    	case CARDSTATUS_TAPABLE : {
    		float x = (canvas.getWidth()  - cardBitmap.getWidth() ) / 2 + (dragX - offsetX);
    		float y = (canvas.getHeight() - cardBitmap.getHeight()) / 2 + (dragY - offsetY);
	    	canvas.drawBitmap( cardBitmap, x, y, paint );
	    	break;
    	}
    	
    	}
    }
	
	@Override 
	public boolean onTouchEvent(MotionEvent event) {

		switch( event.getAction() ){

		//G
		case MotionEvent.ACTION_DOWN :
			offsetX = dragX = event.getX();
			offsetY = dragY = event.getY();
			break;
    	
        //G܂܃XCh
		case MotionEvent.ACTION_MOVE :
			dragX = event.getX();
			dragY = event.getY();
			break;
			
		//
		case MotionEvent.ACTION_UP :
		case MotionEvent.ACTION_CANCEL :
			if( rangeX <= (dragX - offsetX) ){
				startSnapOut();
			}
			else{
				//̈ʒuɖ߂
				resetPosition();
			}
			
			break;
		}    	

        // ĕ`̎w
        invalidate();
        
        return true;
    }
	
	
	private void resetPosition(){
		offsetX = dragX = 0;
		offsetY = dragY = 0;
	}

	public void startSnapOut(){
		if( cardStatus == CARDSTATUS_TAPABLE ){
			cardStatus = CARDSTATUS_SNAPOUT;
	        invalidate();
		}
	}
	
	public void startSnapIn(){
		if( cardStatus == CARDSTATUS_INVISIBLE ){
			cardStatus = CARDSTATUS_SNAPIN;
			offsetX = dragX = 0;
			offsetY = 0;
			dragY   = - cardBitmap.getHeight();
			snapInCount = 0;
	        invalidate();
		}
	}
	
}
