package jp.coocan.la.aide.android.snapcard;

import java.util.List;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Color;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.net.Uri;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.widget.FrameLayout;


public class MainActivity extends Activity implements SensorEventListener {

	private final int REQUEST_GALLERY = 1;

	private MainView mainView;
	private SensorManager sensorManager = null;
	private boolean isRegiseredSensor = false;

	private float oldAccelerometerValue = 0.0f;

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		initializeApplicationContainer();

		FrameLayout layout = new FrameLayout( this );
		layout.setBackgroundColor( Color.BLACK );
		setContentView(layout);

		mainView = new MainView( this );
		layout.addView( mainView );

		//センサー準備
		sensorManager = (SensorManager)getSystemService(SENSOR_SERVICE);
	}




	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		super.onCreateOptionsMenu( menu );

		this.getMenuInflater().inflate( R.menu.main, menu );

		return true;
	}


	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		super.onOptionsItemSelected(item);

		switch(item.getItemId()){

		case R.id.menu_gallery : {
			startSelectCardImage();
			return true;
		}

		}

		return false;
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
		super.onActivityResult( requestCode, resultCode, intent );

		if (resultCode != RESULT_OK) return;

		switch( requestCode ){

		case REQUEST_GALLERY :{
			completeSelectCardImage( intent );
		}

		}
	}


	@Override
	protected void onResume() {
		super.onResume();

		//加速度センサーのリスナー登録
		List<Sensor> sensors = sensorManager.getSensorList(Sensor.TYPE_ACCELEROMETER);
		if (sensors.size() > 0) {
			Sensor sensor = sensors.get(0);
			isRegiseredSensor = sensorManager.registerListener(
					this,
					sensor,
					SensorManager.SENSOR_DELAY_UI
					);
		}
	}

	@Override
	protected void onPause() {
		//加速度センサーのリスナー登録解除
		if (isRegiseredSensor) {
			sensorManager.unregisterListener( this );
			isRegiseredSensor = false;
		}

		super.onPause();
	}



	public boolean onTouchEvent(MotionEvent event) {

		switch( event.getAction() ){

		//触る
		case MotionEvent.ACTION_DOWN :
			mainView.onStartDrag( event.getX(), event.getY() );
			break;

			//触ったままスライド
		case MotionEvent.ACTION_MOVE :
			mainView.onDragging( event.getX(), event.getY() );
			break;

			//離す
		case MotionEvent.ACTION_UP :
		case MotionEvent.ACTION_CANCEL :
			mainView.onEndDrag( event.getX(), event.getY() );

			break;
		}    	

		return true;
	}


	public void onAccuracyChanged(Sensor sensor, int accuracy) {

	}


	public void onSensorChanged(SensorEvent event) {

		if( event.sensor.getType() == Sensor.TYPE_ACCELEROMETER ){
			if( event.values[1] - oldAccelerometerValue >= 2.5f ){
				mainView.onShake();
			}

			oldAccelerometerValue = event.values[1];
		}
	}


	public void initializeApplicationContainer(){

		//DisplayMetricsを初期化
		DisplayMetrics displayMetrics = new DisplayMetrics();
		this.getWindowManager().getDefaultDisplay().getMetrics( displayMetrics );
		ApplicationContainer.setDisplayMetrics( displayMetrics );

		//ContentResolverを初期化
		ApplicationContainer.setContentResolver( getContentResolver() );
	}

	public void startSelectCardImage(){
		Intent intent = new Intent();
		intent.setType( "image/*" );
		intent.setAction( Intent.ACTION_PICK );
		intent.addCategory(Intent.CATEGORY_DEFAULT);
		startActivityForResult( intent, REQUEST_GALLERY );
	}

	public void completeSelectCardImage(Intent intent){
		Uri uri= intent.getData();

		mainView.loadCardBitmap( uri );
	}


}