
CREATE TABLE monitoring_table (
	uukey_in       int not null,
	msnumber_in    int not null,
	moproto_in     int not null,
	serverkey_in   int not null,
	modport_in     int not null,
	mailprno_in    int not null,
	mailreno_in    int not null,
	mostat_in      int not null,
	msps_in        int,
	premsps_in     int,
	moextime_lin   bigint,
	expitime_lin   bigint,
	modhost_ch1024 varchar(1024),
	moptions_ch1024 varchar(1024),
	moinfo_ch1024  varchar(1024),
	mukey_in       serial
);

COMMENT ON TABLE monitoring_table IS 'monitoring table.';
COMMENT ON COLUMN monitoring_table.uukey_in IS 'user unique key.';
COMMENT ON COLUMN monitoring_table.msnumber_in IS 'monitor serial number.';
COMMENT ON COLUMN monitoring_table.moproto_in IS 'monitoring protocol.';
COMMENT ON COLUMN monitoring_table.serverkey_in IS 'monitoring server ID.';
COMMENT ON COLUMN monitoring_table.modport_in IS 'monitoring destination port number.';
COMMENT ON COLUMN monitoring_table.mailprno_in IS 'For the problem notification.';
COMMENT ON COLUMN monitoring_table.mailreno_in IS 'For the restoration notification.';
COMMENT ON COLUMN monitoring_table.mostat_in IS 'monitoring status.';
COMMENT ON COLUMN monitoring_table.msps_in IS 'mail sending process status.';
COMMENT ON COLUMN monitoring_table.premsps_in IS 'Monitoring the status of the previous.';
COMMENT ON COLUMN monitoring_table.moextime_lin IS 'monitor excution time.';
COMMENT ON COLUMN monitoring_table.expitime_lin IS 'expiration date.';
COMMENT ON COLUMN monitoring_table.modhost_ch1024 IS 'monitoring destination host.';
COMMENT ON COLUMN monitoring_table.moptions_ch1024 IS 'monitoring options.';
COMMENT ON COLUMN monitoring_table.moinfo_ch1024 IS 'monitoring infomations.';
COMMENT ON COLUMN monitoring_table.mukey_in IS 'monitor unique key.';

