<?php
// --- コンフィグレーション ---
include './include/config.inc';

// --- time zone set ---
date_default_timezone_set($__timezone);

// --- グローバル変数設定 ---
$_set = 0;
$_login_name ="";
$_pass_word ="";
$_session = 0;

// ---  関数のインクルード ---
include './include/php/user_auth_db.inc';
include './include/php/enco.inc';
include './include/php/db.inc';


// --- POST データの処理 ---
if (!empty($_POST)){
   $SET = cmd_replace(htmlspecialchars((int)$_POST["SET"]));
   if(preg_match("/^[0-9]+$/", $SET)){ $_set = $SET; } else{ $_set = 0; }

   $_login_name = cmd_replace(htmlspecialchars($_POST["LOGIN_NAME"]));
   $_pass_word = cmd_replace(htmlspecialchars($_POST["PASS_WORD"]));
   }


// --- 画面処理 ---
// --- _set0 初期 LOGIN ---
if( $_set == 0 ){
   $_set = 1;
   include './include/html/html_login1.inc';                     // ログイン画面に飛ぶ
   }

// --- _set1 認証確認 ---
else if( $_set == 1 ){
   if(0 == user_auth_db($_login_name, $_pass_word)){            // 認証設定
      include './include/php/session_start.inc';                // セッション 開始処理
      $_set = 3;
      include './include/html/html_list.inc';                   // ログイン完了画面に飛ぶ
      }
   else{
      $_set = 1;
      include './include/html/html_login2.inc';                  // ログイン失敗後の再ログイン画面に飛ぶ
      }
   }

// --- _set2 ログイン失敗後の再ログイン画面  ---
else if( $_set == 2 ){
   $_set = 1;
   include './include/html/html_login2.inc';                  // ログイン失敗後の再ログイン画面に飛ぶ
   }

// --- _set3 ログイン完了画面 （一覧画面） --- 
else if( $_set == 3 ){
   include './include/php/session_check.inc';                // セッション 確認処理
   if($_session == 1){
      $_set = 3;
      include './include/html/html_list.inc';
      }
   else{
      $_set = 1;
      include './include/html/html_login1.inc';                // ログイン画面に飛ぶ
      }
   }

// --- _set4 ログアウト完了画面---
else if( $_set == 4 ){
   user_logout($_login_name, $_pass_word);                   // 認証設定
   include './include/php/session_destroy.inc';               // セッション破壊処理
   $_set = 0;
   include './include/html/html_logout.inc';
   }

// --- _set5 ログイン完了画面 （編集画面）--- 
else if( $_set == 5 ){
   include './include/php/session_check.inc';                // セッション 確認処理
   if($_session == 1){
      $_set = 5;
      include './include/html/html_edit.inc';
      }
   else{
      $_set = 1;
      include './include/html/html_login1.inc';                // ログイン画面に飛ぶ
      }
   }

// ---  それら以外の処理画面 
else{
   include './include/php/session_destroy.inc';                 // セッション破壊処理
   $_set = 1;
   include './include/html/html_login1.inc';                     // ログイン画面に飛ぶ
   }


?>



