class CreateCaches < ActiveRecord::Migration
  def change
    create_table :caches do |t|
      t.references :user, null:false
      t.integer :itemtype, null:false
      t.text :path, null:false
      t.string :location, null:false
      t.binary :data
      t.datetime :access_at, null:false

      t.timestamps

      t.index [:user_id, :itemtype, :path, :location], unique:true
    end
  end
end
