﻿/*
  win32_pointer.cpp
  base class of screen driver

  Made by Studio Breeze. 2002

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
 */
#include "stdafx.h"

#include "sted_screen_win32.h"


// notification from main window
void
CSTedScreenWin32::NotifyPointerPosition(int in_x, int in_y, int in_wparam)
{
  fPointerEventNotified = TRUE;

  fCurrentPointerX = in_x;
  fCurrentPointerY = in_y;

  if (in_wparam&MK_LBUTTON)
	  fCurrentPointerButtonStateL = EButtonOn;
  else
	  fCurrentPointerButtonStateL = EButtonOff;
  if (in_wparam&MK_RBUTTON)
	  fCurrentPointerButtonStateR = EButtonOn;
  else
	  fCurrentPointerButtonStateR = EButtonOff;
}

void
CSTedScreenWin32::NotifyPointerButtonState(int in_button, int in_state)
{
  if (in_button==EButtonLeft) {
    fCurrentPointerButtonStateL = in_state;
  } else if (in_button==EButtonRight) {
    fCurrentPointerButtonStateR = in_state;
  }
  fPointerEventNotified = TRUE;
}

// pointer
void 
CSTedScreenWin32::MouseInit(void)
{
  fCurrentPointerX = 0;
  fCurrentPointerY = 0;
  fCurrentPointerButtonStateL = EButtonOff;
  fCurrentPointerButtonStateR = EButtonOff;

  fPointerEventNotified = FALSE;
}

void
CSTedScreenWin32::SetMouseCursorVisible(int in_onoff)
{
  // just ignore
}

int 
CSTedScreenWin32::GetMouseButtonState(void)
{
  int result = 0;

  while (!fPointerEventNotified && !fKeyEventNotified && fKeyBufferAvailable==0) {
	  DoMessageLoop();
  }
  fPointerEventNotified = FALSE;
  fKeyEventNotified = FALSE;

  if (fCurrentPointerButtonStateL==EButtonOn) result|=0xff00;
  if (fCurrentPointerButtonStateR==EButtonOn) result|=0x00ff;

  return result;
}

int
CSTedScreenWin32::SetMouseMoveLimit(int in_x0, int in_y0, int in_x1, int in_y1)
{
  fPointerMinX = in_x0;
  fPointerMaxX = in_x1;
  fPointerMinY = in_y0;
  fPointerMaxY = in_y0;

  return 0;
}

int
CSTedScreenWin32::GetMousePos(int *out_x, int *out_y)
{
  int x,y;

  x = fX68WindowWidth * fCurrentPointerX / fWindowWidth;
  y = fX68WindowHeight * fCurrentPointerY / fWindowHeight;

  if (x<fPointerMinX) x = fPointerMinX;
  if (x>=fPointerMaxX) x = fPointerMaxX;
  if (y<fPointerMinY) y = fPointerMinY;
  if (y>=fPointerMaxY) y = fPointerMaxY;

  if (out_x) *out_x = x;
  if (out_y) *out_y = y;

  return 0;
}

void
CSTedScreenWin32::MouseWait(void)
{
  // Ugh!: implement it!
}
