#pragma once
/*
  ==============================================================================

   This file is part of the async
   Copyright 2005-10 by Satoshi Fujiwara.

   async can be redistributed and/or modified under the terms of the
   GNU General Public License, as published by the Free Software Foundation;
   either version 2 of the License, or (at your option) any later version.

   async is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with async; if not, visit www.gnu.org/licenses or write to the
   Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
   Boston, MA 02111-1307 USA

  ==============================================================================
*/

namespace sf{
  class dpi
  {
  public:
    dpi() : init_(false), dpi_x_(96), dpi_y_(96) { }
    // ʂ DPI 擾܂B
    int dpix() { init(); return dpi_x_; }
    int dpiy() { init(); return dpi_y_; }

    // ΃sNZƑ΃sNZԂ̕ϊs܂B
    int scale_x(int x) { init(); return MulDiv(x, dpi_x_, 96); }
    int scale_y(int y) { init(); return MulDiv(y, dpi_y_, 96); }
    int unscale_x(int x) { init(); return MulDiv(x, 96, dpi_x_); }
    int unscale_y(int y) { init(); return MulDiv(y, 96, dpi_y_); }

    // ʃTCY (΃sNZP) ߂܂B
    int scaled_screen_width() { return scaled_system_metrix_x(SM_CXSCREEN); }
    int scaled_screen_height() { return scaled_system_metrix_y(SM_CYSCREEN); }

    // lp`̃TCY΃sNZ瑊΃sNZɕύX܂B
    void scale_rect(RECT *rect_ptr)
    {
      rect_ptr->left = scale_x(rect_ptr->left);
      rect_ptr->right = scale_x(rect_ptr->right);
      rect_ptr->top = scale_y(rect_ptr->top);
      rect_ptr->bottom = scale_y(rect_ptr->bottom);
    }

    // ʉ𑜓xŒl (΃sNZP) 𖞂Ă邩ǂ
    // mF܂B
    bool is_resolution_at_least(int xmin, int ymin) 
    { 
      return (scaled_screen_width() >= xmin) && (scaled_screen_height() >= ymin); 
    }
    // |Cg TCY (1/72 C`) ΃sNZɕϊ܂B
    int point_to_pixels(int pt) { return MulDiv(pt, dpi_y_, 72); }
    // LbVꂽgbNׂĖɂ܂B
    void invalidate() { init_ = false; }
  private:
    void init();

    int scaled_system_metrix_x(int nIndex) 
    { 
      init(); 
      return MulDiv(GetSystemMetrics(nIndex), 96, dpi_x_); 
    }

    int scaled_system_metrix_y(int nIndex) 
    { 
      init(); 
      return MulDiv(GetSystemMetrics(nIndex), 96, dpi_y_); 
    }

  private:
    bool init_;
    int dpi_x_;
    int dpi_y_;
  };
}
