﻿#pragma once
/*
  ==============================================================================

   Copyright 2005-11 by Satoshi Fujiwara.

   async can be redistributed and/or modified under the terms of the
   GNU General Public License, as published by the Free Software Foundation;
   either version 2 of the License, or (at your option) any later version.

   async is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with async; if not, visit www.gnu.org/licenses or write to the
   Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
   Boston, MA 02111-1307 USA

  ==============================================================================
*/
#include <audioclient.h>
#include "exception.h"
#include "audio_source.h"

namespace sf{

class wave_file_reader : public audio_source
{
    struct exception : public sf::exception
    {
      exception(const std::wstring& reason) : sf::exception(reason) {};
      exception(const wchar_t* reason) : sf::exception(std::wstring(reason)) {};
    };

    FILE *file_;
    
    bool stream_status_;
    fpos_t data_chunk_position;
    uint64_t total_data_bytes_;
    uint64_t data_bytes_remaining_;
    WAVEFORMATEXTENSIBLE wfx_;
    bool repeat_mode_;

public:
    wave_file_reader(const std::wstring file_name, bool repeat_mode);
    ~wave_file_reader();
    bool stream_status() { return stream_status_; };
    WAVEFORMATEXTENSIBLE &get_wave_format()
    {
        return  wfx_ ;
    };

    bool more_data_available()
    {
        return (stream_status_  &&
                (repeat_mode_  || data_bytes_remaining_ > 0));
    };

    uint64_t total_data_bytes() { return total_data_bytes_; }
    uint64_t data_bytes_remaining() { return data_bytes_remaining_; }
    void seek(uint64_t pos);
    void read_data(BYTE *buffer, uint64_t numbytes);
    void reset_data_position();
    HANDLE raw_handle() { return reinterpret_cast<HANDLE>(file_);};
    void wait(int timer = -1) {return;};

};


}

