﻿#include "stdafx.h"
#include "resource.h"
#define BOOST_ASSIGN_MAX_PARAMS 7
#include <boost/assign.hpp>
#include <boost/assign/ptr_list_of.hpp>
#include <boost/assign/ptr_list_inserter.hpp>
#include <boost/foreach.hpp>

#if _DEBUG
#define _CRTDBG_MAP_ALLOC
#include <crtdbg.h>
#define new new(_NORMAL_BLOCK, __FILE__, __LINE__)
#endif

#include "sf_windows.h"
#include "toplevel_window.h"
#include "CommDlg.h"
#include "icon.h"
#include "timer.h"
#include "exception.h"
#include "application.h"

//#pragma comment( lib, "dxguid.lib" )
//#pragma comment( lib, "d3d11.lib" )
//#pragma comment( lib, "d3dx11.lib" )
//#pragma comment( lib, "dxgi.lib" )
//#pragma comment( lib, "d3dx9.lib" )   
#pragma comment( lib, "Shlwapi.lib" ) 

#define THROW_IFERR(hres) \
  if (FAILED(hres)) { throw sf::win32_error_exception(hres); }

#ifndef HINST_THISCOMPONENT
EXTERN_C IMAGE_DOS_HEADER __ImageBase;
#define HINST_THISCOMPONENT ((HINSTANCE)&__ImageBase)
#endif

namespace sf 
{

HRESULT EnableBlurBehind(HWND hwnd)
{
  HRESULT hr = S_OK;

  //Create and populate the BlurBehind structre
  DWM_BLURBEHIND bb = {0};
  //Enable Blur Behind and Blur Region;
  bb.dwFlags = DWM_BB_ENABLE;
  bb.fEnable = true;
  bb.hRgnBlur = NULL;

  //Enable Blur Behind
  hr = DwmEnableBlurBehindWindow(hwnd, &bb);
  if (SUCCEEDED(hr))
  {
    //do more things
  }
  return hr;
}

// 汎用情報格納用
struct mode_info 
{
  mode_info(const std::wstring& n,const std::wstring& d) : name(n),description(d) {}
  std::wstring name;
  std::wstring description;
};

// ディスプレイモード
struct display_mode 
{
  display_mode(const std::wstring& n,const std::wstring& d) : name(n),description(d) {}
  std::wstring name;
  std::wstring description;
};

std::vector<mode_info> display_modes = 
  boost::assign::list_of<mode_info>
(L"DXGI_FORMAT_UNKNOWN",L"フォーマットが不明")
(L"DXGI_FORMAT_R32G32B32A32_TYPELESS",L"4 成分、128 ビット型なしフォーマット 1")
(L"DXGI_FORMAT_R32G32B32A32_FLOAT",L"4 成分、128 ビット浮動小数点フォーマット 1")
(L"DXGI_FORMAT_R32G32B32A32_UINT",L"4 成分、128 ビット符号なし整数フォーマット 1")
(L"DXGI_FORMAT_R32G32B32A32_SINT",L"4 成分、128 ビット符号付き整数フォーマット 1")
(L"DXGI_FORMAT_R32G32B32_TYPELESS",L"3 成分、96 ビット型なしフォーマット")
(L"DXGI_FORMAT_R32G32B32_FLOAT",L"3 成分、96 ビット浮動小数点フォーマット")
(L"DXGI_FORMAT_R32G32B32_UINT",L"3 成分、96 ビット符号なし整数フォーマット")
(L"DXGI_FORMAT_R32G32B32_SINT",L"3 成分、96 ビット符号付き整数フォーマット")
(L"DXGI_FORMAT_R16G16B16A16_TYPELESS",L"4 成分、64 ビット型なしフォーマット")
(L"DXGI_FORMAT_R16G16B16A16_FLOAT",L"4 成分、64 ビット浮動小数点フォーマット")
(L"DXGI_FORMAT_R16G16B16A16_UNORM",L"4 成分、64 ビット符号なし整数フォーマット")
(L"DXGI_FORMAT_R16G16B16A16_UINT",L"4 成分、64 ビット符号なし整数フォーマット")
(L"DXGI_FORMAT_R16G16B16A16_SNORM",L"4 成分、64 ビット符号付き整数フォーマット")
(L"DXGI_FORMAT_R16G16B16A16_SINT",L"4 成分、64 ビット符号付き整数フォーマット")
(L"DXGI_FORMAT_R32G32_TYPELESS",L"2 成分、64 ビット型なしフォーマット")
(L"DXGI_FORMAT_R32G32_FLOAT",L"2 成分、64 ビット浮動小数点フォーマット")
(L"DXGI_FORMAT_R32G32_UINT",L"2 成分、64 ビット符号なし整数フォーマット")
(L"DXGI_FORMAT_R32G32_SINT",L"2 成分、64 ビット符号付き整数フォーマット")
(L"DXGI_FORMAT_R32G8X24_TYPELESS",L"2 成分、64 ビット型なしフォーマット")
(L"DXGI_FORMAT_D32_FLOAT_S8X24_UINT",L"32 ビット浮動小数点成分、および 2 つの符号なし整数成分です (追加の 32 ビットを含む)。")
(L"DXGI_FORMAT_R32_FLOAT_X8X24_TYPELESS",L"32 ビット浮動小数点成分、および 2 つの型なし成分です (追加の 32 ビットを含む)。")
(L"DXGI_FORMAT_X32_TYPELESS_G8X24_UINT",L"32 ビット型なし成分、および 2 つの符号なし整数成分です (追加の 32 ビットを含む)。")
(L"DXGI_FORMAT_R10G10B10A2_TYPELESS",L"4 成分、32 ビット型なしフォーマット")
(L"DXGI_FORMAT_R10G10B10A2_UNORM",L"4 成分、32 ビット符号なし整数フォーマット")
(L"DXGI_FORMAT_R10G10B10A2_UINT",L"4 成分、32 ビット符号なし整数フォーマット")
(L"DXGI_FORMAT_R11G11B10_FLOAT",L"3 成分、32 ビット浮動小数点フォーマット")
(L"DXGI_FORMAT_R8G8B8A8_TYPELESS",L"3 成分、32 ビット型なしフォーマット")
(L"DXGI_FORMAT_R8G8B8A8_UNORM",L"4 成分、32 ビット符号なし整数フォーマット")
(L"DXGI_FORMAT_R8G8B8A8_UNORM_SRGB",L"4 成分、32 ビット符号なし正規化整数 sRGB フォーマット")
(L"DXGI_FORMAT_R8G8B8A8_UINT",L"4 成分、32 ビット符号なし整数フォーマット")
(L"DXGI_FORMAT_R8G8B8A8_SNORM",L"3 成分、32 ビット符号付き整数フォーマット")
(L"DXGI_FORMAT_R8G8B8A8_SINT",L"3 成分、32 ビット符号付き整数フォーマット")
(L"DXGI_FORMAT_R16G16_TYPELESS",L"2 成分、32 ビット型なしフォーマット")
(L"DXGI_FORMAT_R16G16_FLOAT",L"2 成分、32 ビット浮動小数点フォーマット")
(L"DXGI_FORMAT_R16G16_UNORM",L"2 成分、32 ビット符号なし整数フォーマット")
(L"DXGI_FORMAT_R16G16_UINT",L"2 成分、32 ビット符号なし整数フォーマット")
(L"DXGI_FORMAT_R16G16_SNORM",L"2 成分、32 ビット符号付き整数フォーマット")
(L"DXGI_FORMAT_R16G16_SINT",L"2 成分、32 ビット符号付き整数フォーマット")
(L"DXGI_FORMAT_R32_TYPELESS",L"1 成分、32 ビット型なしフォーマット")
(L"DXGI_FORMAT_D32_FLOAT",L"1 成分、32 ビット浮動小数点フォーマット")
(L"DXGI_FORMAT_R32_FLOAT",L"1 成分、32 ビット浮動小数点フォーマット")
(L"DXGI_FORMAT_R32_UINT",L"1 成分、32 ビット符号なし整数フォーマット")
(L"DXGI_FORMAT_R32_SINT",L"1 成分、32 ビット符号付き整数フォーマット")
(L"DXGI_FORMAT_R24G8_TYPELESS",L"2 成分、32 ビット型なしフォーマット")
(L"DXGI_FORMAT_D24_UNORM_S8_UINT",L"深度チャンネルに 24 ビット、ステンシル チャンネルに 8 ビットを使用する 32 ビット Z バッファー フォーマット")
(L"DXGI_FORMAT_R24_UNORM_X8_TYPELESS",L"1 成分、24 ビット符号なし正規化整数と追加の型なし 8 ビットを含む、32 ビット フォーマット")
(L"DXGI_FORMAT_X24_TYPELESS_G8_UINT",L"1 成分、24 ビット型なしフォーマットと追加の 8 ビット符号なし整数成分を含む、32 ビット フォーマット")
(L"DXGI_FORMAT_R8G8_TYPELESS",L"2 成分、16 ビット型なしフォーマット")
(L"DXGI_FORMAT_R8G8_UNORM",L"2 成分、16 ビット符号なし整数フォーマット")
(L"DXGI_FORMAT_R8G8_UINT",L"2 成分、16 ビット符号なし整数フォーマット")
(L"DXGI_FORMAT_R8G8_SNORM",L"2 成分、16 ビット符号付き整数フォーマット")
(L"DXGI_FORMAT_R8G8_SINT",L"2 成分、16 ビット符号付き整数フォーマット")
(L"DXGI_FORMAT_R16_TYPELESS",L"1 成分、16 ビット型なしフォーマット")
(L"DXGI_FORMAT_R16_FLOAT",L"1 成分、16 ビット浮動小数点フォーマット")
(L"DXGI_FORMAT_D16_UNORM",L"1 成分、16 ビット符号なし正規化整数フォーマット")
(L"DXGI_FORMAT_R16_UNORM",L"1 成分、16 ビット符号なし整数フォーマット")
(L"DXGI_FORMAT_R16_UINT",L"1 成分、16 ビット符号なし整数フォーマット")
(L"DXGI_FORMAT_R16_SNORM",L"1 成分、16 ビット符号付き整数フォーマット")
(L"DXGI_FORMAT_R16_SINT",L"1 成分、16 ビット符号付き整数フォーマット")
(L"DXGI_FORMAT_R8_TYPELESS",L"1 成分、8 ビット型なしフォーマット")
(L"DXGI_FORMAT_R8_UNORM",L"1 成分、8 ビット符号なし整数フォーマット")
(L"DXGI_FORMAT_R8_UINT",L"1 成分、8 ビット符号なし整数フォーマット")
(L"DXGI_FORMAT_R8_SNORM",L"1 成分、8 ビット符号付き整数フォーマット")
(L"DXGI_FORMAT_R8_SINT",L"1 成分、8 ビット符号付き整数フォーマット")
(L"DXGI_FORMAT_A8_UNORM",L"1 成分、8 ビット符号なし整数フォーマット")
(L"DXGI_FORMAT_R1_UNORM",L"1 成分、1 ビット符号なし正規化整数フォーマット 2.")
(L"DXGI_FORMAT_R9G9B9E5_SHAREDEXP",L"4 成分、32 ビット浮動小数点フォーマット 2.")
(L"DXGI_FORMAT_R8G8_B8G8_UNORM",L"4 成分、32 ビット符号なし正規化整数フォーマット 3")
(L"DXGI_FORMAT_G8R8_G8B8_UNORM",L"4 成分、32 ビット符号なし正規化整数フォーマット 3")
(L"DXGI_FORMAT_BC1_TYPELESS",L"4 成分、型なしブロック圧縮フォーマット")
(L"DXGI_FORMAT_BC1_UNORM",L"4 成分、ブロック圧縮フォーマット")
(L"DXGI_FORMAT_BC1_UNORM_SRGB",L"sRGB データ用の 4 成分、ブロック圧縮フォーマット")
(L"DXGI_FORMAT_BC2_TYPELESS",L"4 成分、型なしブロック圧縮フォーマット")
(L"DXGI_FORMAT_BC2_UNORM",L"4 成分、ブロック圧縮フォーマット")
(L"DXGI_FORMAT_BC2_UNORM_SRGB",L"sRGB データ用の 4 成分、ブロック圧縮フォーマット")
(L"DXGI_FORMAT_BC3_TYPELESS",L"4 成分、型なしブロック圧縮フォーマット")
(L"DXGI_FORMAT_BC3_UNORM",L"4 成分、ブロック圧縮フォーマット")
(L"DXGI_FORMAT_BC3_UNORM_SRGB",L"sRGB データ用の 4 成分、ブロック圧縮フォーマット")
(L"DXGI_FORMAT_BC4_TYPELESS",L"1 成分、型なしブロック圧縮フォーマット")
(L"DXGI_FORMAT_BC4_UNORM",L"1 成分、ブロック圧縮フォーマット")
(L"DXGI_FORMAT_BC4_SNORM",L"1 成分、ブロック圧縮フォーマット")
(L"DXGI_FORMAT_BC5_TYPELESS",L"2 成分、型なしブロック圧縮フォーマット")
(L"DXGI_FORMAT_BC5_UNORM",L"2 成分、ブロック圧縮フォーマット")
(L"DXGI_FORMAT_BC5_SNORM",L"2 成分、ブロック圧縮フォーマット")
(L"DXGI_FORMAT_B5G6R5_UNORM",L"3 成分、16 ビット符号なし正規化整数フォーマット")
(L"DXGI_FORMAT_B5G5R5A1_UNORM",L"1 ビット アルファをサポートする 4 成分、16 ビット符号なし正規化整数フォーマット")
(L"DXGI_FORMAT_B8G8R8A8_UNORM",L"8 ビット アルファをサポートする 4 成分、16 ビット符号なし正規化整数フォーマット")
(L"DXGI_FORMAT_B8G8R8X8_UNORM",L"4 成分、16 ビット符号なし正規化整数フォーマット")
(L"DXGI_FORMAT_FORCE_UINT",L"コンパイル時に、この列挙型のサイズを 32 ビットにするために定義されています。この値を指定しない場合、一部のコンパイラでは列挙型を 32 ビット以外のサイズでコンパイル可能この定数が使用されることはありません。");

// スキャンライン情報

std::vector<mode_info> scanline_orders = 
  boost::assign::list_of<mode_info>
  (L"DXGI_MODE_SCANLINE_ORDER_UNSPECIFIED",L"走査線の順序が指定されていません。")
  (L"DXGI_MODE_SCANLINE_ORDER_PROGRESSIVE",L"イメージは先頭の走査線～最後の走査線から作成され、スキップされる走査線はありません。")
  (L"DXGI_MODE_SCANLINE_ORDER_UPPER_FIELD_FIRST",L"イメージが上部のフィールドから作成されます。")
  (L"DXGI_MODE_SCANLINE_ORDER_LOWER_FIELD_FIRST",L"イメージが下部のフィールドから作成されます。");

    // スケーリングパラメータ
    std::vector<mode_info> scalings = boost::assign::list_of<mode_info>
      (L"DXGI_MODE_SCALING_UNSPECIFIED",L"スケーリングが指定されていません。")
      (L"DXGI_MODE_SCALING_CENTERED",L"スケーリングなしを指定します。イメージはディスプレイの中央に配置されます。通常、このフラグは固定ドットピッチ ディスプレイ (LED ディスプレイなど) に使用します。")
      (L"DXGI_MODE_SCALING_STRETCHED",L"拡大スケーリングを指定します。");

struct simple_vertex
{
    XMFLOAT3 pos;
    XMFLOAT3 norm;
    XMFLOAT2 tex;
};

struct cb_never_changes
{
    XMMATRIX mView;
	  XMFLOAT4 vLightDir;
};

struct cb_change_on_resize
{
    XMMATRIX mProjection;
};

struct cb_changes_every_frame
{
    XMMATRIX mWorld;
    XMFLOAT4 vLightColor;

    //    XMFLOAT4 vMeshColor;
};

struct slider : public subclass_window
{
  slider() : subclass_window() {};
  void create() {};
  virtual LRESULT window_proc(HWND hwnd,uint32_t message, WPARAM wParam, LPARAM lParam) 
  {
    //switch(message){
    //case WM_HSCROLL :
    //  {
    //    switch(wParam)
    //    {
    //    case TB_THUMBTRACK : 
    //       DWORD dwPos = SendMessage(GetDlgItem(hwnd_,IDC_SLIDER), TBM_GETPOS, 0, 0); 
    //       break; 
    //    }
    //  }
 /*   }*/
    return CallWindowProc(proc_backup_,hwnd,message,wParam,lParam);
  };
};

struct toplevel_window::impl : public base_win32_dialog_t
{

  static const uint32_t SLIDER_MAX = 30000;

  impl(const std::wstring& menu_name,const std::wstring& name,bool fit_to_display,float width = 160,float height = 100) 
    : base_win32_dialog_t(menu_name,name,fit_to_display,width,height) , timer_(*this,100),icon_(IDI_ICON1)/*,mesh_color_(0.7f, 0.7f, 0.7f, 1.0f)*/,init_(false),thumb_start_(false)/*wm_task_bar_create_(0),result_time_(INTERVAL_SEC1),status_(active)*/
  {
    file_name_.reserve(MAX_PATH + 1);
    dir_name_.reserve(MAX_PATH + 1);
    on_render.connect(boost::bind(&impl::render,this));
  };

  ~impl(){
    //safe_release(dxgi_factory_);
    safe_release(factory_);
    safe_release(write_factory_);
  };


  
  // -------------------------------------------------------------------
  // ウィンドウプロシージャ
  // -------------------------------------------------------------------
  LRESULT window_proc(HWND hwnd,uint32_t message, WPARAM wParam, LPARAM lParam){
    switch (message)
    {
    case WM_INITDIALOG:
      {
        // TODO:
        create_device();
        init_control();
        timer_.start();
        //MARGINS mgn = {-1};//left,right,top,bottom
        //HRESULT hr = DwmExtendFrameIntoClientArea(hwnd_, &mgn);
        return TRUE;
      }
      break;
    case WM_HSCROLL :
      {
        switch(LOWORD(wParam))
        {
        case TB_THUMBTRACK :
           
#ifdef _DEBUG
          wdout << L"TB_THUMBTRACK" << std::endl;
#endif
          thumb_start_ = true;
           break;
        case TB_ENDTRACK :
#ifdef _DEBUG
          wdout << L"TB_ENDTRACK" << std::endl;
#endif
           application::instance()->set_play_position(SendMessage(GetDlgItem(hwnd_,IDC_SLIDER), TBM_GETPOS, 0, 0) * application::instance()->get_data_size() / SLIDER_MAX); 

          thumb_start_ = false;
          break;
        case TB_PAGEUP:
          thumb_start_ = true;
          break;
        case TB_PAGEDOWN:
          thumb_start_ = true;
          break;
        default:
#ifdef _DEBUG
          wdout << boost::wformat(L"LOWORD(wParam):%d") % LOWORD(wParam) << std::endl;
#endif
          break;
        }
      }
      break;
    case WM_SIZE:
      {
        // バックバッファなどに関係するインターフェースを解放する
        // バックバッファを解放する
        if(init_)
        {
          calc_client_size();
        }
        // バックバッファなどに関係するインターフェースを再作成する

        //if (render_target_)
        //{
        //	D2D1_SIZE_U size;
        //	size.width = lParam & 0xFFFF;
        //	size.height = (lParam >> 16) & 0xFFFF; ;

        //	// Note: This method can fail, but it's okay to ignore the
        //	// error here -- it will be repeated on the next call to
        //	// EndDraw.
        //	render_target_->Resize(size);
        //}
      }
      break;
    case WM_PAINT:
      {
        //create_device();

        { 
          paint_struct begin_paint(hwnd);
          //CloseHandle(cb);
          // 描画コードの呼び出し
          render();

        }

//        ::ShowWindow(hwnd_,SW_MINIMIZE);
      }
      return FALSE;
    case WM_DISPLAYCHANGE:
      {
        invalidate_rect();
      }
      break;
    case WM_ERASEBKGND:
      {
        //return TRUE;
      }
      break;
    case WM_MOUSEMOVE:
      {
        //					on_mouse_move(GET_X_LPARAM(lParam),GET_Y_LPARAM(lParam),wParam); 
      }
      break;
    case WM_LBUTTONDOWN:
      {
      }
      break;
    case WM_TIMER:
      {
        if(!thumb_start_){
          uint32_t status = application::instance()->get_status(boost::memory_order_relaxed);
          if( status == application::player_play || status == application::player_end)
          {
            uint64_t pos = application::instance()->get_play_position() * SLIDER_MAX / application::instance()->get_data_size(); 
            SendMessage(GetDlgItem(hwnd_,IDC_SLIDER), TBM_SETPOS, (WPARAM)TRUE, (LPARAM)pos);
          }
        }
        return TRUE;
      }
    case WM_DWMCOMPOSITIONCHANGED:
      {
        //MARGINS mgn = {-1,0,0,0};//let,right,top,bottom
        //HRESULT hr = DwmExtendFrameIntoClientArea(hwnd_, &mgn);
      }
      break;
    case WM_COMMAND:
       switch(LOWORD(wParam)){
       case IDC_FILE:
            {
                return get_file_path();
             }
       case IDC_SLIDER:
         //::MessageBox( hwnd_,L"SLIDERが動作しました。",L"IDC_SLIDER",MB_OK);
         return TRUE;
       case IDC_PLAY:
//         ::MessageBox( hwnd_,L"PLAYボタンが押されました。",L"IDC_PLAY",MB_OK);
         application::instance()->play();
         return TRUE;
       case IDC_STOP:
         //::MessageBox( hwnd_,L"STOPボタンが押されました。",L"IDC_STOP",MB_OK);
         application::instance()->stop();
         return TRUE;
       case IDC_PAUSE:
         //::MessageBox( hwnd_,L"PAUSEボタンが押されました。",L"IDC_PAUSE",MB_OK);
         application::instance()->pause();
         return TRUE;
       case IDC_REPEAT_CHECK:
         application::instance()->repeat_mode(::SendMessage(GetDlgItem(hwnd_,IDC_REPEAT_CHECK),BM_GETCHECK,0,0) == BST_CHECKED);
         return TRUE;
       case IDC_EXC_MODE:
         application::instance()->exclusive_mode(::SendMessage(GetDlgItem(hwnd_,IDC_EXC_MODE),BM_GETCHECK,0,0) == BST_CHECKED);
         return TRUE;
       }
 
      //if(HIWORD(wParam) == THBN_CLICKED ){
      //  switch(LOWORD(wParam)){
      //  case THUMB_START:
      //    {
      //      if(status_ != stop)
      //      {
      //        update_status(stop);
      //      } else {
      //        update_status(active);
      //      }
      //    }
      //    break;
      //  }
      //}
      break;
    case WM_PLAY_PLAY:
      play_();
      return TRUE;
    case WM_PLAY_STOP:
      stop_();
      return TRUE;
    case WM_PLAY_PAUSE:
      pause_();
      return TRUE;
        //::SetTimer(hwnd_,(UINT_PTR)&timer_id_,1000,NULL);
    }

    if(message == WM_CLOSE)
    {
      //slider_.detatch();
      timer_.stop();
      // 後始末
      discard_device();
      // レンダーターゲットのリリース
      //safe_release(dcr_);
      safe_release(render_target_);
      // Windowの破棄
      BOOL ret(::DestroyWindow(hwnd));
      BOOST_ASSERT(ret != 0);
    }

    if(message == WM_DESTROY)
    {
      ::PostQuitMessage(0);
      return 0;
    }
//    return ::DefDlgProcW(hwnd,message,wParam,lParam);
//    return ::DefWindowProcW(hwnd,message,wParam,lParam);
    // なぜかDefWindowProcやDefDlgProcではダメ
    return FALSE;
  }
  
  void init_control()
  {
     SendMessage(GetDlgItem(hwnd_,IDC_SLIDER), TBM_SETRANGE, (WPARAM)TRUE, (LPARAM)MAKELONG(0, SLIDER_MAX));
     //slider_.attach(GetDlgItem(hwnd_,IDC_SLIDER));
  }

  void ready()
  {
    // プレイボタンは有効化
    enable_control(IDC_PLAY,true);
    focus(IDC_PLAY);
   // highlight(IDC_PLAY);
    // その他のボタンは無効化
    enable_control(IDC_REPEAT_CHECK,true);
    enable_control(IDC_PAUSE,false);
    enable_control(IDC_SLIDER,true);
    enable_control(IDC_STOP,false);
    enable_control(IDC_EXC_MODE,true);
  }

  void play()
  {
    post_message(WM_PLAY_PLAY,0,0);
  }
  
  void play_()
  {
    enable_control(IDC_PLAY,false);
    enable_control(IDC_STOP,true);
    focus(IDC_STOP);
    //highlight(IDC_STOP);
    enable_control(IDC_REPEAT_CHECK,true);
    enable_control(IDC_PAUSE,true);
    ::SetWindowText(GetDlgItem(hwnd_,IDC_PAUSE),L"一時停止");
    enable_control(IDC_SLIDER,true);
    enable_control(IDC_FILE,false);
    enable_control(IDC_EXC_MODE,false);
  }

  void stop()
  {
    post_message(WM_PLAY_STOP,0,0);
  }

  void stop_()
  {
    enable_control(IDC_PLAY,true);
    focus(IDC_PLAY);
    //highlight(IDC_PLAY);
    enable_control(IDC_REPEAT_CHECK,true);
    enable_control(IDC_STOP,false);
    enable_control(IDC_PAUSE,false);
    enable_control(IDC_SLIDER,true);
    ::SendMessage(GetDlgItem(hwnd_,IDC_SLIDER), TBM_SETPOS, (WPARAM)TRUE, (LPARAM)0);
    enable_control(IDC_FILE,true);
    enable_control(IDC_EXC_MODE,true);
  }
  
  void pause()
  {
    send_message(WM_PLAY_PAUSE,0,0);
  }

  void pause_()
  {
    enable_control(IDC_PLAY,false);
    enable_control(IDC_STOP,false);
    enable_control(IDC_PAUSE,true);
    enable_control(IDC_REPEAT_CHECK,true);
    focus(IDC_PAUSE);
    //highlight(IDC_PAUSE);
    ::SetWindowText(GetDlgItem(hwnd_,IDC_PAUSE),L"再開");
    enable_control(IDC_SLIDER,true);
    enable_control(IDC_FILE,false);
    enable_control(IDC_EXC_MODE,false);
  }

  virtual void create(){
    create_device_independent_resources();
//    icon_ = ::LoadIconW(HINST_THISCOMPONENT,MAKEINTRESOURCE(IDI_ICON1));
    register_class(this->name_.c_str(),CS_HREDRAW | CS_VREDRAW ,0,DLGWINDOWEXTRA,icon_.get());
    create_dialog();

    // 半透明ウィンドウを有効にする。
    //BOOL dwmEnable;
    //DwmIsCompositionEnabled (&dwmEnable); 
    //if (dwmEnable) EnableBlurBehind(*this);

  }

  void create_dialog()
  {
    hwnd_ = ::CreateDialog(HINST_THISCOMPONENT,MAKEINTRESOURCE(IDD_MAINDIALOG),::GetDesktopWindow(),thunk_proc_);
    // ::DialogBox(HINST_THISCOMPONENT,MAKEINTRESOURCE(IDD_MAINDIALOG),0,thunk_proc_);
  }

  virtual void discard_device()
  {
    //safe_release(sampler_state_);
    //safe_release(shader_res_view_);
    //safe_release(cb_changes_every_frame_);
    //safe_release(cb_change_on_resize_);
    //safe_release(cb_never_changes_);
    //safe_release(i_buffer_);
    //safe_release(v_buffer_);
    //safe_release(p_shader_);
    //safe_release(input_layout_);
    //safe_release(v_shader_);
    // discard_swap_chain_dependent_resources();
    safe_release(render_target_);
 /*   safe_release(swap_chain_);
    safe_release(d3d_context_);
    safe_release(d3d_device_);
    safe_release(adapter_);
 */ }

  void calc_client_size()
  {
    //クライアント領域の現在の幅、高さを求める
    RECT rc;
    GetClientRect( hwnd_, &rc );
    client_width_ = rc.right - rc.left;
    client_height_ = rc.bottom - rc.top;
  }

  virtual void create_device(){
    calc_client_size();
    HRESULT hr = S_OK;
    init_ = false;

    if(!render_target_)
    {
      HWND waveform_hwnd = GetDlgItem(hwnd_,IDC_WAVEFORM);
      RECT rc;
      GetClientRect(waveform_hwnd, &rc);
    //  GetClientRect(hwnd_, &rc);

      D2D1_SIZE_U size = D2D1::SizeU(
        rc.right - rc.left,
        rc.bottom - rc.top
        );

      const D2D1_PIXEL_FORMAT format =
        D2D1::PixelFormat(DXGI_FORMAT_B8G8R8A8_UNORM,
        D2D1_ALPHA_MODE_PREMULTIPLIED);

      const D2D1_RENDER_TARGET_PROPERTIES target_prop = 
        D2D1::RenderTargetProperties(D2D1_RENDER_TARGET_TYPE_DEFAULT,format);

      THROW_IFERR(factory_->CreateHwndRenderTarget(
        target_prop,
        D2D1::HwndRenderTargetProperties(waveform_hwnd, size,D2D1_PRESENT_OPTIONS_IMMEDIATELY),
        &render_target_
        ));
        //D2D1::HwndRenderTargetProperties(hwnd_, size,D2D1_PRESENT_OPTIONS_IMMEDIATELY),
        //&render_target_
        //));
    }

    init_ = true;// 初期化完了
  }
  
 
  virtual void create_device_independent_resources()
  {

  
    // Direct2DFactory の生成

    if(!factory_){
#if defined(DEBUG) || defined(_DEBUG)
      D2D1_FACTORY_OPTIONS options;
      options.debugLevel = D2D1_DEBUG_LEVEL_INFORMATION ;
      THROW_IFERR(D2D1CreateFactory(
        D2D1_FACTORY_TYPE_SINGLE_THREADED,
        options,
        &factory_
        ));
#else
      THROW_IFERR(D2D1CreateFactory(D2D1_FACTORY_TYPE_SINGLE_THREADED, &factory_));
#endif

    }

    if(!write_factory_){
      THROW_IFERR(::DWriteCreateFactory(
        DWRITE_FACTORY_TYPE_SHARED,
        __uuidof(IDWriteFactory),
        reinterpret_cast<IUnknown**>(&write_factory_)
        ));
    }


    //wic_imaging_factory_.CreateInstance(CLSID_WICImagingFactory);

    //thunk_proc_ = (WNDPROC)thunk_.getCode();
    layout_rect_ = D2D1::RectF(0.0f,100.0f,400.0f,100.0f);
    // Text Formatの作成
    THROW_IFERR(write_factory_->CreateTextFormat(
    L"メイリオ",                // Font family name.
    NULL,                       // Font collection (NULL sets it to use the system font collection).
    DWRITE_FONT_WEIGHT_REGULAR,
    DWRITE_FONT_STYLE_NORMAL,
    DWRITE_FONT_STRETCH_NORMAL,
    24.0f,
    L"ja-jp",
    &write_text_format_
    ));

  }

  void render(){

    if (render_target_)
    {
      // Retrieve the size of the render target.
      D2D1_SIZE_F renderTargetSize = render_target_->GetSize();
      try {
        render_target_->BeginDraw();
//        render_target_->PushAxisAlignedClip(layout_rect_,D2D1_ANTIALIAS_MODE_ALIASED);
      //  render_target_->Clear(D2D1::ColorF(D2D1::ColorF::AliceBlue));
        //render_target_->FillRectangle(D2D1::RectF(0.0f,0.0f,renderTargetSize.width,renderTargetSize.height),);
        render_target_->SetTransform(D2D1::Matrix3x2F::Identity());
        ID2D1SolidColorBrushPtr brush;
        render_target_->CreateSolidColorBrush(D2D1::ColorF(D2D1::ColorF::OrangeRed), &brush);

        std::wstring m(L"WAVE FORMを描くところ！");
        render_target_->DrawTextW(
          m.c_str(),
          m.size(),
          write_text_format_,
          layout_rect_, 
          brush);
 //       render_target_->PopAxisAlignedClip();
        THROW_IFERR(render_target_->EndDraw());

      } catch(sf::win32_error_exception& err)
      {
        if(err.hresult() == D2DERR_RECREATE_TARGET)
        {
          discard_device();
          create_device();
        } else {
          throw;
        }
      } catch(...) {
        throw;
      }
    }
  }
 

  void create_window()
  {

    // Windowを作成する
    CreateWindowEx(
      WS_EX_APPWINDOW | WS_EX_TOPMOST,
      name_.c_str(),
      title_.c_str(),
      WS_OVERLAPPEDWINDOW & ~WS_THICKFRAME,
      CW_USEDEFAULT,
      CW_USEDEFAULT,
      static_cast<uint32_t>(dpi_.scale_x(width_)),
      static_cast<uint32_t>(dpi_.scale_x(height_)),
      NULL,
      NULL,
      HINST_THISCOMPONENT,
      this
      );
  };

  void get_dxgi_information()
  {
//    int i = 0;
//
//    while(1){
//      IDXGIAdapter1Ptr adapter;
//      HRESULT hr = dxgi_factory_->EnumAdapters1(i,&adapter);
//      if(hr == DXGI_ERROR_NOT_FOUND)
//      {
//        break;
//      }
//      DXGI_ADAPTER_DESC1 desc;
//      adapter->GetDesc1(&desc);
//      //adapter->CheckInterfaceSupport();
//      
//      wdout << desc.Description << std::endl;
//      wdout << desc.DedicatedVideoMemory << std::endl;
//      IDXGIDevice1Ptr device;
//
//      uint32_t oi = 0;
//
//
//      while(1)
//      {
//        IDXGIOutputPtr output;        
//        if(adapter->EnumOutputs(oi,&output) == DXGI_ERROR_NOT_FOUND){
//          break;
//        }
//        DXGI_OUTPUT_DESC output_desc;
//        output->GetDesc(&output_desc); 
//        UINT num = 0;
//        DXGI_FORMAT format = DXGI_FORMAT_R8G8B8A8_UNORM_SRGB;
//        UINT flags         = DXGI_ENUM_MODES_INTERLACED | DXGI_ENUM_MODES_SCALING;
//
//        output->GetDisplayModeList(format,flags,&num,0);
//        boost::shared_array<DXGI_MODE_DESC> disp_modes(new DXGI_MODE_DESC[num]);
//        output->GetDisplayModeList(format,flags,&num,&disp_modes[0]);
//        //output->GetFrameStatistics
//        for(uint32_t mode_index = 0;mode_index < num;++mode_index)
//        {
//          DXGI_MODE_DESC& mode(disp_modes[mode_index]);
//          wdout << boost::wformat(L"Format: %s %s \n Width: %d Height: %d RefleshRate: %d/%d Scaling:%s %s \n Scanline: %s %s ")
//            %  display_modes[mode.Format].name % display_modes[mode.Format].description
//            %  mode.Width % mode.Height 
//            %  mode.RefreshRate.Numerator % mode.RefreshRate.Denominator
//            %  scalings[mode.Scaling].name %  scalings[mode.Scaling].description
//            %  scanline_orders[mode.ScanlineOrdering].name
//            %  scanline_orders[mode.ScanlineOrdering].description
//            << std::endl;
//        }
////        output->
//        wdout << output_desc.DeviceName << std::endl; 
//        oi++;
//      }
//
//      adapter.Release();
//      ++i;
//    }
  }

  void enable_control(uint32_t id,bool enable)
  {
    ::EnableWindow(GetDlgItem(hwnd_,id),enable?TRUE:FALSE);
  }

  // コントロールにフォーカスを移動する
  // id ... コントロールID
  void focus(uint32_t id)
  {
    // 間違い
    // ::SetFocus(GetDlgItem(hwnd_,id));
   
    // 正解
    post_message(WM_NEXTDLGCTL,(WPARAM)GetDlgItem(hwnd_,id),TRUE);
  }

  void highlight(uint32_t id)
  {
   Button_SetState(GetDlgItem(hwnd_,id),TRUE);
  }

private:

  void read_start() {};
  BOOL get_file_path ()
  {
    WCHAR file_name[MAX_PATH]  = L"";  // ファイル名
    WCHAR dir_name[MAX_PATH]   = L"";  // ディレクトリ

    WCHAR file_title[MAX_PATH] = L"";  // ダイアログのタイトル
    OPENFILENAME ofn;              

    if (dir_name_.empty())
    {
      GetWindowsDirectory(dir_name, MAX_PATH);
      dir_name_.assign(dir_name);
    }

    if(!file_name_.empty())
    {
      wcscpy_s(file_name,MAX_PATH,dir_name_.c_str());
    }

    // Set up structure for file dialog
    ZeroMemory(&ofn, sizeof(ofn));
    ofn.lStructSize = sizeof(OPENFILENAME);
    ofn.hwndOwner = ::GetDesktopWindow();
    ofn.lpstrFilter = L"Wave File (*.wav)\0*.WAV\0";
    ofn.lpstrCustomFilter = NULL;
    ofn.nFilterIndex = 1;
    ofn.lpstrFile = file_name;
    ofn.nMaxFile = MAX_PATH;
    ofn.lpstrFileTitle = file_title;
    ofn.nMaxFileTitle = MAX_PATH;
    ofn.lpstrInitialDir = dir_name;
    ofn.lpstrTitle = L".WAVファイルを指定してください。";
    ofn.lpstrDefExt = L"wav";
    ofn.Flags = OFN_SHAREAWARE | OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

    // Put up Open File dialog to get file name.
    if (GetOpenFileName(&ofn))
    {
      file_name_.assign(file_name);
      sf::application::instance()->setup(file_name);
    }
    return TRUE;
  }
  
  //long wm_task_bar_create_;
  //sf::taskbar taskbar_;
  
  timer timer_;
  bool thumb_start_;
  //slider slider_;

  //IDXGIFactory1Ptr dxgi_factory_;
  //IDXGIAdapter1Ptr adapter_;
  //IDXGIOutputPtr output_;
  //ID3D11DevicePtr d3d_device_;
  //ID3D11DeviceContextPtr d3d_context_;
  //ID3D11Texture2DPtr texture_;
  //ID3D11RenderTargetViewPtr view_;
  //ID3D11Texture2DPtr depth_texture_;
  //ID3D11DepthStencilViewPtr depth_view_;
  //ID3D11VertexShaderPtr v_shader_;
  //ID3D11InputLayoutPtr input_layout_;
  //ID3D11PixelShaderPtr p_shader_;
  //ID3D11BufferPtr v_buffer_;
  //ID3D11BufferPtr i_buffer_;
  //ID3D11BufferPtr cb_never_changes_;
  //ID3D11BufferPtr cb_change_on_resize_;
  //ID3D11BufferPtr cb_changes_every_frame_;
  //ID3D11ShaderResourceViewPtr shader_res_view_;
  //ID3D11SamplerStatePtr sampler_state_;

  //XMMATRIX                            mat_world_;
  //XMMATRIX                            mat_view_;
  //XMMATRIX                            mat_projection_;
  //XMFLOAT4                            mesh_color_;

  float client_width_,client_height_;
  
  //IDXGISwapChainPtr; 
  ID2D1FactoryPtr factory_;
  ID2D1HwndRenderTargetPtr render_target_;
  IDWriteFactoryPtr write_factory_;
  IWICImagingFactoryPtr wic_imaging_factory_;
  IDWriteTextFormatPtr write_text_format_;
  //IDXGISwapChainPtr swap_chain_;
  std::wstring dxgi_info_;

  std::wstring file_name_;
  std::wstring dir_name_;
  icon icon_;
  bool init_;

  D2D1_RECT_F layout_rect_;
  D2D1_SIZE_U icon_size_;
};

  //
  // Creates a Direct2D bitmap from the specified
  // file name.
  //
  ID2D1BitmapPtr load_bitmap_from_file(
    ID2D1HwndRenderTargetPtr render_target,
    IWICImagingFactoryPtr wic_factory,
    std::wstring uri,
    uint32_t destination_width,
    uint32_t destination_height
    )
  {
    HRESULT hr = S_OK;

    IWICBitmapDecoderPtr decoder;
    IWICBitmapFrameDecodePtr decoder_source;
    IWICStreamPtr stream;
    IWICFormatConverterPtr converter;
    IWICBitmapScalerPtr scaler;
    ID2D1BitmapPtr bitmap;

    THROW_IFERR(wic_factory->CreateDecoderFromFilename(
      uri.c_str(),
      NULL,
      GENERIC_READ,
      WICDecodeMetadataCacheOnLoad,
      &decoder
      ));

    // Create the initial frame.
    THROW_IFERR(decoder->GetFrame(0, &decoder_source));

    // Convert the image format to 32bppPBGRA
    // (DXGI_FORMAT_B8G8R8A8_UNORM + D2D1_ALPHA_MODE_PREMULTIPLIED).
    THROW_IFERR(hr = wic_factory->CreateFormatConverter(&converter));

    // If a new width or height was specified, create an
    // IWICBitmapScaler and use it to resize the image.
    if (destination_width != 0 || destination_height != 0)
    {
      uint32_t originalWidth, originalHeight;
      THROW_IFERR(decoder_source->GetSize((UINT*)&originalWidth, (UINT*)&originalHeight));
      if (destination_width == 0)
      {
        FLOAT scalar = static_cast<FLOAT>(destination_height) / static_cast<FLOAT>(originalHeight);
        destination_width = static_cast<uint32_t>(scalar * static_cast<FLOAT>(originalWidth));
      }
      else if (destination_height == 0)
      {
        FLOAT scalar = static_cast<FLOAT>(destination_width) / static_cast<FLOAT>(originalWidth);
        destination_height = static_cast<uint32_t>(scalar * static_cast<FLOAT>(originalHeight));
      }

      THROW_IFERR(wic_factory->CreateBitmapScaler(&scaler));
      THROW_IFERR(scaler->Initialize(
        decoder_source,
        destination_width,
        destination_height,
        WICBitmapInterpolationModeCubic
        ));
      THROW_IFERR(converter->Initialize(
        scaler.GetInterfacePtr(),
        GUID_WICPixelFormat32bppPBGRA,
        WICBitmapDitherTypeNone,
        NULL,
        0.f,
        WICBitmapPaletteTypeMedianCut
        ));
    }
    else // Don't scale the image.
    {
      THROW_IFERR(converter->Initialize(
        decoder_source.GetInterfacePtr(),
        GUID_WICPixelFormat32bppPBGRA,
        WICBitmapDitherTypeNone,
        NULL,
        0.f,
        WICBitmapPaletteTypeMedianCut
        ));
    }

    // Create a Direct2D bitmap from the WIC bitmap.
    THROW_IFERR(render_target->CreateBitmapFromWicBitmap(
      converter.GetInterfacePtr(),
      NULL,
      &bitmap
      ));

    return bitmap;
  }
  
  toplevel_window::toplevel_window(const std::wstring& menu_name,const std::wstring& name,bool fit_to_display,float width ,float height)
    : impl_(new impl(menu_name,name,fit_to_display,width,height))
  {

  };

  void * toplevel_window::raw_handle() const {return impl_->raw_handle();};
  void toplevel_window::create(){impl_->create();};
  void toplevel_window::show(){impl_->show();};
  void toplevel_window::hide(){impl_->hide();};
  bool toplevel_window::is_show(){return impl_->is_show();};
  void toplevel_window::text(std::wstring& text){impl_->text(text);};
  void toplevel_window::message_box(const std::wstring& text,const std::wstring& caption,uint32_t type )
    {
      impl_->message_box(text,caption,type);
  };
  void toplevel_window::update(){impl_->update();};
  void toplevel_window::render(){impl_->render();};
  void toplevel_window::ready(){impl_->ready();};
  void toplevel_window::play(){impl_->play();};
  void toplevel_window::pause(){impl_->pause();};
  void toplevel_window::stop(){impl_->stop();};

  void toplevel_window::enable_control(uint32_t id,bool enable)
  {
      impl_->enable_control(id,enable);
  };


 toplevel_window_ptr create_toplevel_window
    (
    const std::wstring& menu_name,
    const std::wstring& name,
    const uint32_t show_flag,
    bool fit_to_display,
    float width,
    float height
    )
  {
// クライアント領域のサイズからウィンドウサイズを設定
RECT    rect    = { 0, 0, width, height };
::AdjustWindowRectEx( &rect, WS_OVERLAPPEDWINDOW & ~WS_THICKFRAME, FALSE, 0 );
    toplevel_window* p = new toplevel_window(menu_name,name,fit_to_display,rect.right - rect.left,rect.bottom - rect.top);
    p->create();
    p->show();
    p->update();
    return toplevel_window_ptr(p);
  }
   void dialogbox
    (
    const std::wstring& menu_name,
    const std::wstring& name
    )
   {
    toplevel_window_ptr p(new toplevel_window(menu_name,name,false));
    p->create();
   }
}

