#pragma once
/*
  ==============================================================================

   Copyright 2005-11 by Satoshi Fujiwara.

   async can be redistributed and/or modified under the terms of the
   GNU General Public License, as published by the Free Software Foundation;
   either version 2 of the License, or (at your option) any later version.

   async is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with async; if not, visit www.gnu.org/licenses or write to the
   Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
   Boston, MA 02111-1307 USA

  ==============================================================================
*/
// WASAPI
#include "exception.h"
#include <mmdeviceapi.h>
#include <AudioClient.h>
#include <audiopolicy.h>

#define _USE_MATH_DEFINES
#include <math.h>
#include <limits.h>
#pragma comment(lib, "winmm.lib")
#pragma comment(lib, "Avrt.lib")

#include "audio_base.h"

// COM Pointer `
_COM_SMARTPTR_TYPEDEF(IMMDeviceEnumerator,__uuidof(IMMDeviceEnumerator));
_COM_SMARTPTR_TYPEDEF(IMMDevice,__uuidof(IMMDevice));
_COM_SMARTPTR_TYPEDEF(IAudioClient,__uuidof(IAudioClient));
_COM_SMARTPTR_TYPEDEF(IAudioRenderClient,__uuidof(IAudioRenderClient));
_COM_SMARTPTR_TYPEDEF(IAudioClockAdjustment,__uuidof(IAudioClockAdjustment));

namespace sf {

struct device_manager
{
  IMMDeviceEnumeratorPtr mm_device_enumerator;
};


/// WASAPINX(LE^C}[[h)
struct wasapi_shared_timer : public audio_base
{
  explicit wasapi_shared_timer(::WAVEFORMATEXTENSIBLE& wfx);
  virtual ~wasapi_shared_timer();

  bool is_enabled () const {return is_enabled_;}
 
  /// eXgp TCgf[^̐
  void create_wave_data();

  /// TEhĐ
  void play_buffer(BYTE* buffer);
  void stop();
  void reset();

  uint32_t get_buffer_byte_size () const { return buffer_size_ * num_of_frames_;}
  win32_error_exception* const result() {return exception_holder_.get(); }

private:
  IMMDeviceEnumeratorPtr device_enumerator_;
  IMMDevicePtr current_device_;
  IAudioClientPtr audio_client_;
  IAudioRenderClientPtr audio_render_client_;
  IAudioClockAdjustmentPtr audio_clock_adjustment_;
  //handle_holder buffer_control_event_;
  WAVEFORMATEXTENSIBLE mix_format_;
  bool is_enabled_;
  bool is_start_;
  boost::shared_ptr<win32_error_exception> exception_holder_;
  boost::uint32_t num_of_frames_;
  boost::uint32_t buffer_size_;
  uint64_t position_;
  std::vector<short> tone_buffer_;

  // ĐCeV
  static const uint32_t latency_ms_ = 100;/* ms */
  // obt@̋؂萔iCeVԂ邩j
  static const uint32_t periods_per_buffer_ = 4;
};

/// WASAPINX(rE^C}[[h)
struct wasapi_exclusive_timer : public audio_base
{
  explicit wasapi_exclusive_timer(::WAVEFORMATEXTENSIBLE& wfx);
  virtual ~wasapi_exclusive_timer();

  bool is_enabled () const {return is_enabled_;}
 
  /// TEhĐ
  void play_buffer(BYTE* buffer);
  void stop();
  void reset();

  uint32_t get_buffer_byte_size () const { return buffer_size_ * num_of_frames_;}
  win32_error_exception* const result() {return exception_holder_.get(); }

private:
  IMMDeviceEnumeratorPtr device_enumerator_;
  IMMDevicePtr current_device_;
  IAudioClientPtr audio_client_;
  IAudioRenderClientPtr audio_render_client_;
  IAudioClockAdjustmentPtr audio_clock_adjustment_;
  //handle_holder buffer_control_event_;
  WAVEFORMATEXTENSIBLE mix_format_;
  bool is_enabled_;
  bool is_start_;
  boost::shared_ptr<win32_error_exception> exception_holder_;
  boost::uint32_t num_of_frames_;
  boost::uint32_t buffer_size_;
  uint64_t position_;

  // ĐCeV
  static const uint32_t latency_ms_ = 10;/* ms */
  // obt@̋؂萔iCeVԂ邩j
  static const uint32_t periods_per_buffer_ = 4;
};

}

