﻿//
// App.xaml.cpp
// App クラスの実装。
//

#include "pch.h"
#include "App.xaml.h"
#include "MainPage.xaml.h"
#include "BasicMath.h"

using namespace SynthApp;

using namespace Platform;
using namespace Windows::ApplicationModel;
using namespace Windows::ApplicationModel::Activation;
using namespace Windows::Foundation;
using namespace Windows::Foundation::Collections;
using namespace Windows::UI::Xaml;
using namespace Windows::UI::Xaml::Controls;
using namespace Windows::UI::Xaml::Controls::Primitives;
using namespace Windows::UI::Xaml::Data;
using namespace Windows::UI::Xaml::Input;
using namespace Windows::UI::Xaml::Interop;
using namespace Windows::UI::Xaml::Media;
using namespace Windows::UI::Xaml::Navigation;
using namespace concurrency;
using namespace DirectX;


// 空のアプリケーション テンプレートについては、http://go.microsoft.com/fwlink/?LinkId=234227 を参照してください

/// <summary>
/// 単一アプリケーション オブジェクトを初期化します。これは、実行される作成したコードの
/// 最初の行であり、main() または WinMain() と論理的に等価です。
/// </summary>
App::App() :   soundStopped_(::CreateEventEx(NULL, NULL, 0, EVENT_MODIFY_STATE | SYNCHRONIZE)),isDestroy_(true)
{
  InitializeComponent();
  Suspending += ref new SuspendingEventHandler(this, &App::OnSuspending);
}

App::~App()
{
  if(!isDestroy_)
  {
    StopSound();
  }
  
}
/// <summary>
/// アプリケーションがエンド ユーザーによって正常に起動されたときに呼び出されます。他のエントリ ポイントは、
/// アプリケーションが特定のファイルを開くために呼び出されたときに
/// 検索結果やその他の情報を表示するために使用されます。
/// </summary>
/// <param name="pArgs">Details about the launch request and process.</param>
void App::OnLaunched(Windows::ApplicationModel::Activation::LaunchActivatedEventArgs^ pArgs)
{
  // Do not repeat app initialization when already running, just ensure that
  // the window is active
  if (pArgs->PreviousExecutionState == ApplicationExecutionState::Running)
  {
    Window::Current->Activate();
    return;
  }

  soundDriver_.reset(new sf::SoundDriver());
  soundManager_.reset(new sf::SoundManager(*soundDriver_.get()));
  InitSound();

  if (pArgs->PreviousExecutionState == ApplicationExecutionState::Terminated)
  {
    //TODO: 以前中断したアプリケーションから状態を読み込みます。
  }

  // ナビゲーション コンテキストとして動作するフレームを作成し、最初のページに移動します
  auto rootFrame = ref new Frame();
  if (!rootFrame->Navigate(TypeName(MainPage::typeid)))
  {
    throw ref new FailureException("Failed to create initial page");
  }

  // フレームを現在のウィンドウに配置し、アクティブであることを確認します
  Window::Current->Content = rootFrame;
  Window::Current->Activate();

  StartSound();

}

/// <summary>
/// アプリケーションの実行が中断されたときに呼び出されます。アプリケーションの状態は、
/// アプリケーションが終了されるのか、メモリの内容がそのままで再開されるのか
/// わからない状態で保存されます。
/// </summary>
/// <param name="sender">中断要求の送信元。</param>
/// <param name="e">中断要求の詳細。</param>
void App::OnSuspending(Object^ sender, SuspendingEventArgs^ e)
{
  (void) sender;	// Unused parameter
  (void) e;	// Unused parameter

  //TODO: アプリケーションの状態を保存してバックグラウンドの動作があれば停止します
}

void App::InitSound()
{
  sf::SoundManager& sm(*soundManager_.get());
  sm.Synthesizer().isEnable(false);
  sm.Synthesizer().Clear();
  //        sm.Synthesizer().WaveTables().clear();

  // 鋸波テーブルを作る
  {
    sf::Synthesizer::WaveTable sawtbl;
    sawtbl.sampleRate = 440.0f;
    sawtbl.basePitch = 0.0f;
    sawtbl.stereo = false;

    float v = -1.0f,d = 2.0f / 1024.0f;
    for(int  i = 0;i < 1024;++i)
    {
      //        if(i < 15) v = -1.0f; else v = 1.0f; 
      sawtbl.waveData.push_back(v) ;
      v += d;
    }
    sm.Synthesizer().WaveTables().push_back(std::move(sawtbl));
  }

  // 矩形波テーブルを作る
  {
    sf::Synthesizer::WaveTable squaretbl;
    squaretbl.sampleRate = 440.0f;
    squaretbl.basePitch = 0.0f;
    squaretbl.stereo = false;

    float v = 0.0f;
    for(int  i = 0;i < 32;++i)
    {
      if(i < 15) v = -1.0f; else v = 1.0f; 
      squaretbl.waveData.push_back(v) ;
    }
    sm.Synthesizer().WaveTables().push_back(std::move(squaretbl));
  }

  // 三角波テーブル
  {
    sf::Synthesizer::WaveTable tritbl;
    tritbl.sampleRate = 440.0f;
    tritbl.basePitch = 0.0f;
    tritbl.stereo = false;

    float v = -1.0f,d = 2.0f / 16.0f;
    for(int  i = 0;i < 32;++i)
    {
      if(i < 15) d = -d; 
      tritbl.waveData.push_back(v) ;
      v += d;
    }
    sm.Synthesizer().WaveTables().push_back(std::move(tritbl));
  }

  // sinテーブル
  {
    sf::Synthesizer::WaveTable sintbl;
    sintbl.sampleRate = 440.0f;
    sintbl.basePitch = 0.0f;
    sintbl.stereo = false;

    float v = 0.0f,d = 2.0f * M_PI / 128.0f;
    for(int  i = 0;i < 128;++i)
    {
      sintbl.waveData.push_back(sinf(v));
      v += d;
    }
    sm.Synthesizer().WaveTables().push_back(std::move(sintbl));
  }

  // LFO用 Sinテーブル
  {
    sf::Synthesizer::WaveTable sintbl;
    sintbl.sampleRate = 440.0f;
    sintbl.basePitch = 0.0f;
    sintbl.stereo = false;

    float v = 0.0f,d = 2.0f * M_PI / 128.0f;
    for(int  i = 0;i < 128;++i)
    {
      sintbl.waveData.push_back(sinf(v) / 2.0f + 0.5f);
      v += d;
    }
    sm.Synthesizer().WaveTables().push_back(std::move(sintbl));
  }




  //      ::OutputDebugStringW((boost::wformat(L"waveTable size: %d") % osc_[0].WaveData().size()).str().c_str());

  // timberのセットアップ
  for(int i = 0; i < 4;++i){

    sf::Synthesizer::Timber timber;
    timber.oscillator.reset(new sf::Synthesizer::WaveTableOscillator(&sm.Synthesizer().WaveTables().at(0)));
    timber.amplitude.gain = 1.0f;
    timber.amplitude.envelope.releaseNoteOff = true;
    timber.amplitude.envelope.attackTime = 0.01f;
    timber.amplitude.envelope.decayTime = 0.02f;
    timber.amplitude.envelope.sustainLevel = 0.5f;
    timber.amplitude.envelope.releaseTime = 0.2f;
    timber.amplitude.envelope.gain = 1.0f;
    timber.amplitude.lfo.waveForm = &(sm.Synthesizer().WaveTables()[4]);
    timber.amplitude.lfo.freq = 5.0f;
    timber.amplitude.lfo.gain = 0.0f;

    timber.pitch.lfo.freq = 10.0f;
    timber.pitch.lfo.gain = 0.000f;
    timber.pitch.lfo.waveForm = &(sm.Synthesizer().WaveTables()[4]);
    timber.pitch.lfo.startNoteOn = true;
    timber.pitch.envelope.attackTime = 0.0f;
    timber.pitch.envelope.decayTime = 0.02f;
    timber.pitch.envelope.sustainLevel = 0.5f;
    timber.pitch.envelope.gain =0.0f;
    timber.pitch.pitch = 0.0f;

    timber.pan.lfo.freq = 2.0f;
    timber.pan.lfo.gain = 1.0f;
    timber.pan.lfo.waveForm = &(sm.Synthesizer().WaveTables()[3]);
    timber.pan.lfo.startNoteOn = true;
    timber.pan.envelope.enable = false;
    timber.pan.lfo.envelope.enable = false;
    timber.pan.pan = 0.0f;

    timber.filter.lfo.freq = 5.0f;
    timber.filter.lfo.gain = 1.0f;
    timber.filter.lfo.waveForm = &(sm.Synthesizer().WaveTables()[3]);
    timber.filter.lfo.startNoteOn = true;
    timber.filter.cutoff = 10000.0f;
    timber.filter.resonance = 0.0f;
    timber.filter.envelope.attackTime = 0.01f;
    timber.filter.envelope.decayTime = 0.03f;
    timber.filter.envelope.sustainLevel = 0.05f;
    timber.filter.envelope.releaseTime = 0.2f;
    timber.filter.envelope.gain = 10000.0f;

    sm.Synthesizer().AddProgram(sf::Synthesizer::Program(std::move((boost::wformat(L"Program No.%d") % i).str()),std::move(timber)));   
    //        timbers_.push_back(std::move(timber));
  }

  for(int i = 0,end = sm.Synthesizer().Voices();i < end;++i)
  {
    sm.Synthesizer().AssignProgramToVoice(0,i);
  }

  sm.Synthesizer().isEnable(true);
}

void App::StartSound()
{
  if(isDestroy_) {
    isDestroy_ = false;
    // サウンド再生スレッドの開始
    soundTask_ = task<void>(create_async([this]()
    {
      ExecuteSoundThread();
    })
      );
  }
}

void App::StopSound()
{
  // サウンド再生スレッドの停止
  if(!isDestroy_){
    isDestroy_ = true;
    WaitForSingleObjectEx(soundStopped_.get(),INFINITE,FALSE);
  }
}
// サウンド再生スレッド
void App::ExecuteSoundThread()
{
  //sf::com_init comInit;
  //  InitSound();
  soundManager_->Sequencer().Play();
  while(!isDestroy_)
  {
    soundDriver_->Render();
    //		Concurrency::wait(800);
    //	soundDriver_->Update();
    //	soundDriver_->Render();
  }
  ::SetEvent(soundStopped_.get());
  //isDestroy_ = false;
}