#import "ControllerView.h"

@implementation ControllerView

- (id)initWithFrame:(NSRect)frameRect{
    [super initWithFrame:frameRect];
    return self;
}

- (void)drawRect:(NSRect)rect{
    [_bgImage dissolveToPoint:NSZeroPoint fraction:1];
    
    int i;
    for(i=0;i<DISPLAY_ITEM_NUM;i++)
        if(_displayItemDisplay[i])
            [_displayItem[i] compositeToPoint:_displayItemOrigin[i] operation:NSCompositeSourceOver fraction:1];
    for(i=0;i<DISPLAY_TEXT_NUM;i++)
        if(_displayText[i])
            [_displayText[i] drawInRect:_displayTextRect[i]];
}


-(void)setImage:(NSImage*)img{
    [_bgImage release];
    _bgImage=[img retain];
}

-(void)setDisplayImage:(NSImage*)img andOrigin:(NSPoint)p forTag:(int)tag{
    [_displayItem[tag] release];
    _displayItem[tag]=[img retain];
    _displayItemOrigin[tag]=p;
}

-(void)setDisplayHtml:(NSArray*)ary andRect:(NSRect)r forTag:(int)tag{
    [_displayHtml[tag] release];
    _displayHtml[tag]=[ary retain];
    _displayTextRect[tag]=r;
}


-(void)setDisplayItemDisplay:(BOOL)b forTag:(int)tag{
    _displayItemDisplay[tag]=b;
}

-(void)setAllDisplayItem:(BOOL)b{
    int i;
    for(i=0;i<DISPLAY_ITEM_NUM;i++) _displayItemDisplay[i]=b;
}

-(void)setDisplayText:(NSString*)str forTag:(int)tag{
    [_displayText[tag] release];
    _displayText[tag]=
        [[NSAttributedString alloc]
            initWithHTML:
                [[NSString stringWithFormat:@"%@%@%@",
                    [_displayHtml[tag] objectAtIndex:0],str,[_displayHtml[tag] objectAtIndex:1]]
                        dataUsingEncoding:NSUnicodeStringEncoding]
            documentAttributes:nil];
}


-(void)dealloc{
    int i;
    
    for(i=0;i<DISPLAY_ITEM_NUM;i++) [_displayItem[i] release];
    for(i=0;i<DISPLAY_TEXT_NUM;i++) [_displayHtml[i] release];
    for(i=0;i<DISPLAY_TEXT_NUM;i++) [_displayText[i] release];
    [_bgImage release];
    [super dealloc];
}

@end
