//
//  ControllerSkin.m
//  VH7PC_Controller
//
//  Created by nya on Tue Aug 12 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

#import "ControllerSkin.h"
#import "ControllerButtonCell.h"
#import "ControllerButton.h"

NSString *_buttonKey[BUTTON_NUM]={
    @"Tape/AUX",
    @"MD",
    @"Tuner",
    @"CD",
    @"PCUSB",
    @"Band",
    @"Repeat",
    @"Mute",
    @"N.B.",
    @"Auto",
    @"Eject",
    @"SkipDown",
    @"FB",
    @"Play",
    @"Stop",
    @"FF",
    @"SkipUp",
    @"Power",
    @"Random",
    @"Volume+1",
    @"Volume-1"
};

NSString *_displayKey[DISPLAY_ITEM_NUM]={
    @"Random",
    @"Repeat",
    @"RepeatAll",
    @"Tone",
    @"N.B.1",
    @"N.B.2",
    @"Mute",
    @"Automono"
};

NSString *_displayTextKey[DISPLAY_TEXT_NUM]={
    @"DisplayInput",
    @"DisplayNumber",
    @"DisplayVolume"
};

@implementation ControllerSkin

+(id)skinWithPath:(NSString*)path{
    return [[[ControllerSkin alloc] initWithPath:path] autorelease];
}

-(id)initWithPath:(NSString*)path{
    [super init];
    if(!(_bundle=[[NSBundle alloc] initWithPath:path])){
        [self release];
        return nil;
    }
    if(!(_skinDictionary=[[NSDictionary alloc] initWithContentsOfFile:
        [_bundle pathForResource:@"definition" ofType:@"plist"]])){
            [self release];
            return nil;
    }
    return self;
}

-(NSString*)name{
    return [_skinDictionary objectForKey:@"Name"];
}

-(NSImage*)backgroundImage{
    id tmp=[_skinDictionary objectForKey:@"BackgroundImage"];
    //NSLog(@"%@",tmp);
    id obj=[_bundle pathForResource:tmp ofType:nil];
    if(!obj) return nil;
    NSImage* img=[[NSImage alloc] initWithContentsOfFile:obj];
    return [img autorelease];
}

-(NSTextField*)displayTextFieldForTag:(int)tag{
    id obj=[_skinDictionary objectForKey:[NSString stringWithFormat:@"%@%@",_displayTextKey[tag],@"_Rect"]];
    if(!obj) return nil;
    NSRect r=NSRectFromString(obj);
    
    NSTextField* fld=[[NSTextField alloc] init];
    [fld setFrame:r];
    [fld setEditable:NO];
    [fld setSelectable:NO];
    [fld setBordered:NO];
    [fld setBezeled:NO];
    [fld setDrawsBackground:NO];
    
    return [fld autorelease];
}

-(NSArray*)displayTextForTag:(int)tag inRect:(NSRect*)rect{
    NSString* html=[_skinDictionary objectForKey:[NSString stringWithFormat:@"%@%@",_displayTextKey[tag],@"_HTML"]];
    if(!html) return nil;
    //NSLog(html);
    id obj=[_skinDictionary objectForKey:[NSString stringWithFormat:@"%@%@",_displayTextKey[tag],@"_Rect"]];
    if(!obj) return nil;
    *rect=NSRectFromString(obj);
    
    NSArray* ary=[html componentsSeparatedByString:@"*****"];
    if([ary  count]!=2) return nil;
    return ary;
}

-(NSImage*)displayImageForTag:(int)tag andOrigin:(NSPoint*)point{
    id obj=[_bundle pathForResource:[_skinDictionary objectForKey:
        [NSString stringWithFormat:@"%@%@",_displayKey[tag],@"_DisplayImage"]] ofType:nil];
    if(!obj) return nil;
    NSImage* img=[[NSImage alloc] initWithContentsOfFile:obj];
    if(!img) return nil;
    if(!(obj=[_skinDictionary objectForKey:[NSString stringWithFormat:@"%@%@",_displayKey[tag],@"_DisplayOrigin"]])){
        [img release];
        return nil;
    }
    
    *point=NSPointFromString(obj);
    return [img autorelease];
}

-(NSSlider*)volumeSlider{
    id tmp=[_skinDictionary objectForKey:@"SliderFrame"];
    if(!tmp) return nil;
    NSRect r=NSRectFromString(tmp);
    NSSlider* slider=[[NSSlider alloc] initWithFrame:r];
    [slider setMaxValue:80];
    [slider setMinValue:0];
    [slider setAllowsTickMarkValuesOnly:NO];
    [slider setContinuous:YES];
    //[slider sizeToFit];
    
    return [slider autorelease];
}

-(NSButton*)buttonForTag:(button)tag{
    id obj=[_bundle pathForResource:[_skinDictionary objectForKey:
        [NSString stringWithFormat:@"%@%@",_buttonKey[tag],@"_ButtonImage"]] ofType:nil];
    if(!obj) return nil;
    NSImage* img=[[NSImage alloc] initWithContentsOfFile:obj];
    if(!img) return nil;
    if(!(obj=[_skinDictionary objectForKey:[NSString stringWithFormat:@"%@%@",_buttonKey[tag],@"_ButtonOrigin"]])){
        [img release];
        return nil;
    }
    NSRect r;
    r.size=[img size];
    r.origin=NSPointFromString(obj);
    
    ControllerButton* btn=[[ControllerButton alloc] init];
    [btn setCell:[[ControllerButtonCell alloc] init]];
    [btn setFrame:r];
    [btn setImage:img];
    [btn setButtonType:(tag<eject_b?NSPushOnPushOffButton:NSMomentaryPushInButton)];
    [btn setImagePosition:NSImageOnly];
    [btn setBordered:NO];
    [btn setTag:tag];
    
    return [btn autorelease];
}

-(void)dealloc{
    [_bundle release];
    [_skinDictionary release];
    [super dealloc];
}

@end
