//
//  CHAppleScript.m
//  CatearSelector
//
//  Created by NYA on Fri Jan 10 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

#import "CHAppleScript.h"


@implementation CHAppleScript

+(id)scriptWithFileName:(NSString *)s{
    NSDictionary *err;

    return [[[NSAppleScript alloc] initWithContentsOfURL:[NSURL fileURLWithPath:
            [[[NSBundle mainBundle] resourcePath] stringByAppendingPathComponent:s]] error:&err] autorelease];
}

+(id)scriptWithSource:(NSString *)s{
    return [[[NSAppleScript alloc] initWithSource:s] autorelease];
}

+(NSAppleEventDescriptor *)executeScriptWithFileName:(NSString *)s{
    NSDictionary *err;
    
    return [[self scriptWithFileName:s] executeAndReturnError:&err];
}

+(NSAppleEventDescriptor *)executeScriptWithSource:(NSString *)s{
    NSDictionary *err;
    
    return [[self scriptWithSource:s] executeAndReturnError:&err];
}

+(NSAppleEventDescriptor *)executeScriptWithFileName:(NSString *)s substitution:(NSString *)sub to:(NSString *)str{
    return [self executeScriptWithSource:[NSString stringWithContentsOfFile:
                    [[[NSBundle mainBundle] resourcePath] stringByAppendingPathComponent:s]] substitution:sub to:str];
}

+(NSAppleEventDescriptor *)executeScriptWithSource:(NSString *)s substitution:(NSString *)sub to:(NSString *)str{
    NSArray *array=[s componentsSeparatedByString:sub];
    
    return [self executeScriptWithSource:
                [[[array objectAtIndex:0] stringByAppendingString:str] stringByAppendingString:[array objectAtIndex:1]]];
}

+(NSAppleEventDescriptor *)openURL:(NSString *)url{
    return [self executeScriptWithSource:[NSString stringWithFormat:@"open location \"%@\"",url]];
}

@end
