/*
*Timer main source
*(C) 2014 VOSystems.
*/
#include<stdio.h>
#include<timer.h>

timer_mgr timer;

void settimer(unsigned int timeout,struct msg* msg,unsigned char data)
{
	int i;
	io_cli();
	for(i=0;timer.timers[i]->timeout==0;i++);
	timer.timers[i-1]->timeout=timeout;
	timer.timers[i-1]->msg=msg;
	timer.timers[i-1]->data=data;
	io_sti();
	return;
}

struct timer* timer_alloc(void)
{
	int i;
	for(i=0;i<MAX_TIMER;i++)
	{
		if(timer.timers[i]->flags==0)
		{
			timer.timers[i]->flags=TIMER_FLAGS_ALLOC;
			return &timer.timers[i];
		}
	}
	return NULL;
}

inline void timer_free(struct timer* timer)
{
	timer->flags=0;
	return;
}

inline void timer_init(struct timer* timer,struct msg_data* fifo,unsigned char data)
{
	timer->msg=fifo;
	timer->data=data;
	return;
}

inline void timer_settime(struct timer* timer,unsigned int timeout,int data)
{
	timer->timeout=timeout;
	timer->data=data;
	return;
}
