#ifndef _GDT_IDT_VANE_
#define _GDT_IDT_VANE_

void setupInterruptGate( int int_num, void *interrupt_handler );
void setupGateDescriptor( int int_num,int base,unsigned short selector,unsigned char flags );
void load_gdt(void);
void load_idt(void);


/*GDT Segment Descriptor*/
typedef struct
{
	unsigned short	limitLo;
	unsigned short	baseLo;
	unsigned char	baseMid;
	unsigned short	flags;
	unsigned char	baseHi;
} __attribute__ ((packed)) SEGMENT_DESCRIPTOR;


typedef struct
{
	unsigned short		size;
	SEGMENT_DESCRIPTOR*	base;
} __attribute__ ((packed)) GDTR;

/*IDT*/
typedef struct
{
	unsigned short	baseLo;
	unsigned short	selector;
	unsigned char	reserved;
	unsigned char	flags;
	unsigned short	baseHi;
} __attribute__ ((packed)) GATE_DESCRIPTOR;

typedef struct
{
	unsigned short		size;
	GATE_DESCRIPTOR*	base;
} __attribute__ ((packed)) IDTR;

/*DEFINES*/
/*IDT*/

#define	NUM_IDT	256

#define	DEF_IDT_FLAGS_INTGATE_16BIT		0x06
#define	DEF_IDT_FLAGS_TSKGATE			0x05
#define	DEF_IDT_FLAGS_CALL_GATE			0x0C
#define	DEF_IDT_FLAGS_INTGATE_32BIT		0x0E
#define	DEF_IDT_FLAGS_TRPGATE			0x0F
#define	DEF_IDT_FLAGS_DPL_LV0			0x00
#define	DEF_IDT_FLAGS_DPL_LV1			0x20
#define	DEF_IDT_FLAGS_DPL_LV2			0x40
#define	DEF_IDT_FLAGS_DPL_LV3			0x60
#define	DEF_IDT_FLAGS_PRESENT			0x80

#define DEF_IDT_INT_NUM_IRQ1 			33
#define DEF_IDT_INT_NUM_IRQ0			32
#define DEF_IDT_INT_NUM_SYSC			0x30
#define DEF_IDT_INT_NUM_V86I			0x31
#define DEF_IDT_INT_NUM_V86O			0x32

#define	DEF_IDT_INT_SELECTOR			0x08

/*GDT*/
#define	NUM_GDT	3
#define	NULL_DESCRIPTOR			0
#define	CODE_DESCRIPTOR			1
#define	DATA_DESCRIPTOR			2
#define	TEMP_DESCRIPTOR			3
#define	TASK_CODE_DESCRIPTOR	3
#define	TASK_DATA_DESCRIPTOR	4
#define	KTSS_DESCRIPTOR			5

/* Null Descriptor		*/
#define	DEF_GDT_NULL_LIMIT		0x0000
#define	DEF_GDT_NULL_BASELO		0x0000
#define	DEF_GDT_NULL_BASEMID	0x00
#define	DEF_GDT_NULL_FLAGS		0x0000
#define	DEF_GDT_NULL_BASEHI		0x00

/* Code Descriptor		*/
#define	DEF_GDT_CODE_LIMIT		0xFFFF
#define	DEF_GDT_CODE_BASELO		0x0000
#define	DEF_GDT_CODE_BASEMID	0x00
#define	DEF_GDT_CODE_FLAGS_BL	0x9A
#define	DEF_GDT_CODE_FLAGS_BH	0xCF
#define	DEF_GDT_CODE_FLAGS		0xCF9A
#define	DEF_GDT_CODE_BASEHI		0x00

/* Data Descriptor		*/
#define	DEF_GDT_DATA_LIMIT		0xFFFF
#define	DEF_GDT_DATA_BASELO		0x0000
#define	DEF_GDT_DATA_BASEMID	0x00
#define	DEF_GDT_DATA_FLAGS		0xCF92
#define	DEF_GDT_DATA_FLAGS_BL	0x92
#define	DEF_GDT_DATA_FLAGS_BH	0xCF
#define	DEF_GDT_DATA_BASEHI		0x00

/*PIC*/
#define	PORT_MASTER_PIC_COMMAND	0x0020
#define	PORT_MASTER_PIC_STATUS	0x0020
#define	PORT_MASTER_PIC_DATA	0x0021
#define	PORT_MASTER_PIC_IMR		0x0021
#define	PORT_SLAVE_PIC_COMMAND	0x00A0
#define	PORT_SLAVE_PIC_STATUS	0x00A0
#define	PORT_SLAVE_PIC_DATA		0x00A1
#define	PORT_SLAVE_PIC_IMR		0x00A1
#define	PIC_ICW1				0x11
#define	PIC_MASTER_ICW2			0x20
#define	PIC_SLAVE_ICW2			0x28
#define	PIC_MASTER_ICW3			0x04
#define	PIC_SLAVE_ICW3			0x02
#define	PIC_MASTER_ICW4			0x01
#define	PIC_SLAVE_ICW4			0x01

/*IRQ*/
#define	PIC_IMR_MASK_IRQ0		0x01
#define	PIC_IMR_MASK_IRQ1		0x02
#define	PIC_IMR_MASK_IRQ2		0x04
#define	PIC_IMR_MASK_IRQ3		0x08
#define	PIC_IMR_MASK_IRQ4		0x10
#define	PIC_IMR_MASK_IRQ5		0x20
#define	PIC_IMR_MASK_IRQ6		0x40
#define	PIC_IMR_MASK_IRQ7		0x80
#define	PIC_IMR_MASK_IRQ_ALL	0xFF

/*PIT*/
#define	PIT_REG_COUNTER0			0x0040
#define	PIT_REG_COUNTER1			0x0041
#define	PIT_REG_COUNTER2			0x0042
#define	PIT_REG_CONTROL				0x0043
#define	DEF_PIT_CLOCK				1193181.67	
#define	DEF_PIT_COM_MASK_BINCOUNT	0x01
#define	DEF_PIT_COM_MASK_MODE		0x0E
#define	DEF_PIT_COM_MASK_RL			0x30
#define	DEF_PIT_COM_MASK_COUNTER	0xC0
#define	DEF_PIT_COM_BINCOUNT_BIN	0x00
#define	DEF_PIT_COM_BINCOUNT_BCD	0x01
#define	DEF_PIT_COM_MODE_TERMINAL	0x00
#define	DEF_PIT_COM_MODE_PROGONE	0x02
#define	DEF_PIT_COM_MODE_RATEGEN	0x04
#define	DEF_PIT_COM_MODE_SQUAREWAVE	0x06
#define	DEF_PIT_COM_MODE_SOFTTRIG	0x08
#define	DEF_PIT_COM_MODE_HARDTRIG	0x0A
#define	DEF_PIT_COM_RL_LATCH		0x00
#define	DEF_PIT_COM_RL_LSBONLY		0x10
#define	DEF_PIT_COM_RL_MSBONLY		0x20
#define	DEF_PIT_COM_RL_DATA			0x30
#define DEF_PIT_COM_COUNTER0		0x00
#define	DEF_PIT_COM_COUNTER1		0x40
#define	DEF_PIT_COM_COUNTER2		0x80

/*EXTERN*/
extern IDTR idtr;
extern GATE_DESCRIPTOR	idt[ NUM_IDT ];
extern SEGMENT_DESCRIPTOR	gdt[ NUM_GDT ];
extern GDTR gdtr;


#endif
