/**
 * @file ad7999.h
 * @author takemasa
 * @brief AD7999制御プログラム
 * @details
 * AD7999制御タスク及びAPI。cfgファイルから読み込んで使う
 */


#ifndef AD7999_H_
#define AD7999_H_

#include "uzume.h"

/*
* タスク優先順位はGUIや一般タスクより低くても構わない。
* タスク優先順位とスタックサイズを変更する場合には sys_config.h でマクロ宣言する
*/
#ifndef AD7999_TASK_PRIORITY
#define AD7999_TASK_PRIORITY 7
#endif

#ifndef AD7999_TASK_STACK_SIZE
#define AD7999_TASK_STACK_SIZE 1024
#endif


#ifndef _MACRO_ONLY

extern void ad7999_task(VP_INT exinf);
extern fract32 ad7999_get_volume(unsigned int ch);

#endif
#endif /* AD7999_H_ */
