package org.unitedfront2.web.flow;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.webflow.context.servlet.FlowUrlHandler;

public class FlowUrlHandlerTest {

    private FlowUrlHandler flowUrlHandler;

    @Before
    public void setUp() {
        flowUrlHandler = new org.unitedfront2.web.flow.FlowUrlHandler();
    }

    @Test
    public void testGetFlowIdKw\t[IDԂ邩() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/unitedfront2");
        request.setRequestURI("/unitedfront2/dir/page.html");
        Assert.assertEquals("dir.page-flow", flowUrlHandler.getFlowId(request));
    }

    @Test
    public void testGetFlowIdKw\Ȃt[IDԂ邩() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/unitedfront2");
        request.setRequestURI("/unitedfront2/index.html");
        Assert.assertEquals("index-flow", flowUrlHandler.getFlowId(request));
    }

    @Test
    public void testGetFlowIdt@CȂt[IDԂ邩() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/unitedfront2");
        request.setRequestURI("/unitedfront2/dir/");
        Assert.assertEquals("dir.index-flow", flowUrlHandler.getFlowId(request));
    }

    @Test
    public void testGetFlowId[gKw̃t[IDԂ邩() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/unitedfront2");
        request.setRequestURI("/unitedfront2/");
        Assert.assertEquals("index-flow", flowUrlHandler.getFlowId(request));
    }
}
