package org.unitedfront2.validation;

import org.junit.Assert;
import org.junit.Test;

public class HtmlValidateTest {

    @Test
    public void testHtmlTextȃGXP[v() {
        String text = "ɂ<span style=\"font-weight: bold; text-decoration: underline;\">eX^[</span><br/>"
            + "<span style=\"font-style: italic;\">SPAN</span> ^Ǒ<br/>"
            + "<ol><li></li><li>Α</li><li></li></ol>"
            + "<span style=\"font-style: italic;\">DIV</span> ^Ǒ<br/>"
            + "<ul><li>Cfg</li><li>񂹁AZ^OA<i>E</i></li></ul>"
            + "<div style=\"text-align: left;\">E</div>"
            + "<div style=\"text-align: center;\">Z^O</div>"
            + "<div style=\"text-align: right;\">E</div>"
            + "<div><a href=\"http://www.example.com/\">example.com</a></div>"
            + "<dl><dt>`</dt><dd></dd></dl>"
            + "<table><tr><th>TH</th><td>TD</td></tr></table>";
        try {
            HtmlValidate.htmlText(text);
            Assert.assertTrue(true);
        } catch (ValidationException e) {
            Assert.fail();
        }
    }

    @Test(expected=ValidationException.class)
    public void testHtmlTextGXP[vs\() {
        String text = "1<2";
        HtmlValidate.htmlText(text);
    }

    @Test(expected=ValidationException.class)
    public void testHtmlTextĂȂ^O܂܂Ă() {
        String text = "ɂ<script>eX^[</script>B";
        HtmlValidate.htmlText(text);
    }

    @Test(expected=ValidationException.class)
    public void testHtmlTextSPAN^OɋĂȂX^C܂܂Ă() {
        String text = "ɂ<span style=\"color: red;\">eX^[</span>B";
        HtmlValidate.htmlText(text);
    }

    @Test(expected=ValidationException.class)
    public void testHtmlTextDIV^OɋĂȂX^C܂܂Ă() {
        String text = "<div style=\"color: red;\">ɂ̓eX^[B</div>";
        HtmlValidate.htmlText(text);
    }

    @Test(expected=ValidationException.class)
    public void testHtmlText^O̍\s() {
        String text = "<p>ɂ <span style=\"font-weight: bold;\">eX^[B</p></span>";
        HtmlValidate.htmlText(text);
    }

    @Test(expected=ValidationException.class)
    public void testHtmlTextỸ^O() {
        String text = "<p>ɂ <span style=\"font-weight: bold;\">eX^[</span>B";
        HtmlValidate.htmlText(text);
    }

    @Test
    public void testHtmlText󔒂BR^O() {
        String text = "ɂ̓eX^[B<br />͏ł";
        HtmlValidate.htmlText(text);
    }

    @Test(expected=ValidationException.class)
    public void testHtmlTextsȑ() {
        String text = "<p width=\"1000px\">ɂ̓eX^[B<br />͏ł</p>";
        HtmlValidate.htmlText(text);
    }

    @Test
    public void testHtmlTextBR^OɃX^C܂߂邱Ƃ\() {
        String text = "ɂ̓eX^[B<br style=\"font-weight: bold;\"/>͏ł";
        HtmlValidate.htmlText(text);
    }

    @Test(expected=ValidationException.class)
    public void testHtmlTextULLI^O̍\s() {
        String text = "<li><ul>something</ul></li>";
        HtmlValidate.htmlText(text);
    }

    @Test(expected=ValidationException.class)
    public void testHtmlTextLI^O̍\s() {
        String text = "<li>something</li>";
        HtmlValidate.htmlText(text);
    }

    @Test(expected=ValidationException.class)
    public void testHtmlTextUL^O̍\s() {
        String text = "<ul>something</ul>";
        HtmlValidate.htmlText(text);
    }

    @Test(expected=ValidationException.class)
    public void testHtmlTextOL^O̍\s() {
        String text = "<ol>something</ol>";
        HtmlValidate.htmlText(text);
    }

    @Test(expected=ValidationException.class)
    public void testHtmlTextTABLETR̍\s() {
        String text = "<tr><table>something</table></tr>";
        HtmlValidate.htmlText(text);
    }

    @Test(expected=ValidationException.class)
    public void testHtmlTextTRTH̍\s() {
        String text = "<tr><th>something</th></tr>";
        HtmlValidate.htmlText(text);
    }

    @Test(expected=ValidationException.class)
    public void testHtmlTextTABLE̍\s() {
        String text = "<table>something</table>";
        HtmlValidate.htmlText(text);
    }

    @Test(expected=ValidationException.class)
    public void testHtmlTextTR̍\s() {
        String text = "<tr>something</tr>";
        HtmlValidate.htmlText(text);
    }

    @Test(expected=ValidationException.class)
    public void testHtmlTextTD̍\s() {
        String text = "<td>something</td>";
        HtmlValidate.htmlText(text);
    }

    @Test(expected=ValidationException.class)
    public void testHtmlTextDL̍\s() {
        String text = "<dl>something</dl>";
        HtmlValidate.htmlText(text);
    }

    @Test(expected=ValidationException.class)
    public void testHtmlTextDT̍\s() {
        String text = "<dt>something</dt>";
        HtmlValidate.htmlText(text);
    }

    @Test(expected=ValidationException.class)
    public void testHtmlTextDD̍\s() {
        String text = "<dd>something</dd>";
        HtmlValidate.htmlText(text);
    }

    @Test(expected=ValidationException.class)
    public void testHtmlTextDLDT̍\s() {
        String text = "<dt><dl>something</dl></dt>";
        HtmlValidate.htmlText(text);
    }
}
