package org.unitedfront2.test;

import org.junit.Assert;
import org.junit.Test;
import org.unitedfront2.dao.Registerable;
import org.unitedfront2.dao.SimpleDeletable;
import org.unitedfront2.dao.SimpleFindable;
import org.unitedfront2.dao.Updatable;
import org.unitedfront2.util.PropertyUtils;

/**
 * <code>find</code> A<code>register</code> A<code>update</code> A
 * <code>delete</code> \bh̃eXgP[X DAO p̃eXgP[XłBsvȃeXgP[X
 * TuNXŃI[o[ChA{@link org.junit.Ignore} Ame[Vt^ĂB
 *
 * @author kurokkie
 *
 * @param <DOMAIN> {@link SimpleFindable}  DOMAIN ƍ킹ĂB
 */
public abstract class DaoTestCaseSupport<DOMAIN>
    extends TransactionalTestCaseWithInitialData {

    /** ID ̃vpeB̃ftHg (id) */
    public static final String DEFAULT_PRIMARY_KEY_PROPERTY_NAME = "id";

    @Test
    public void testFindFound() throws Exception {
        DOMAIN expected = createTestDomain();
        register(expected);

        DOMAIN actual = find(getId(expected));
        Assert.assertNotNull(actual);
        Assert.assertEquals(expected, actual);
        afterFindFound(expected);
    }

    /**
     * {@link #testFindFound()} \bh̏ɎsANVłB̃\bh̃ftHg
     * ͉܂BKvɉăTuNXŃI[o[[h܂B
     *
     * @param domain hCIuWFNg
     */
    protected void afterFindFound(DOMAIN domain) {
    }

    @Test
    public void testFindNotFound() {
        DOMAIN actual = find(-1);
        Assert.assertNull(actual);
    }

    @Test
    public void testRegister() {
        DOMAIN expected = createTestDomain();

        register(expected);
        Assert.assertNotNull(PropertyUtils.getProperty(expected,
            getPrimaryKeyPropertyName()));
        Assert.assertEquals(expected, find(getId(expected)));
        afterTestRegister(expected);
    }

    /**
     * {@link #testRegister()} \bh̏ɎsANVłB̃\bh̃ftHg̓
     * ͉܂BKvɉăTuNXŃI[o[[h܂B
     *
     * @param domain hCIuWFNg
     */
    protected void afterTestRegister(DOMAIN domain) {
    }

    @Test
    public void testUpdate() {
        DOMAIN expected = createTestDomain();
        register(expected);
        editTestDomain(expected);

        Assert.assertNotNull(PropertyUtils.getProperty(expected,
                getPrimaryKeyPropertyName()));
        Assert.assertNotNull(find(getId(expected)));
        update(expected);
        Assert.assertEquals(expected, find(getId(expected)));
        afterTestUpdate(expected);
    }

    /**
     * {@link #testUpdate()} \bh̏ɎsANVłB̃\bh̃ftHg̓
     * ͉܂BKvɉăTuNXŃI[o[[h܂B
     *
     * @param domain hCIuWFNg
     */
    protected void afterTestUpdate(DOMAIN domain) {
    }

    @Test
    public void testDelete() {
        DOMAIN expected = createTestDomain();
        register(expected);

        Assert.assertNotNull(find(getId(expected)));
        delete((Integer) PropertyUtils.getProperty(expected,
            getPrimaryKeyPropertyName()));
        Assert.assertNull(find(getId(expected)));
        afterTestDelete(expected);
    }

    /**
     * {@link #testDelete()} \bh̏ɎsANVłB̃\bh̃ftHg̓
     * ͉܂BKvɉăTuNXŃI[o[[h܂B
     *
     * @param domain hCIuWFNg
     */
    protected void afterTestDelete(DOMAIN domain) {
    }

    protected String getPrimaryKeyPropertyName() {
        return DEFAULT_PRIMARY_KEY_PROPERTY_NAME;
    }

    /**
     * eXgP[X {@link #testUpdate()} ̎邽߂ɁAXVf[^쐬
     * B
     *
     * @param domain XVpɕҏWhCIuWFNg
     */
    protected abstract void editTestDomain(DOMAIN domain);

    /**
     * eXgf[^ݒς݂̃hCIuWFNg𐶐܂B
     *
     * @return eXgf[^ݒς݂̃hCIuWFNg
     */
    protected abstract DOMAIN createTestDomain();

    /**
     * TuNXŐ錾f[^ANZXIuWFNg擾܂B
     *
     * @return f[^ANZXIuWFNg
     */
    protected abstract Object getDao();

    /**
     * hCIuWFNgo^܂Bf[^ANZXIuWFNgA{@link Registerable} Ă
     * 邱ƂOƂĂ܂BKvɉăTuNXŃI[o[ChĂB
     *
     * @param domain hCIuWFNg
     */
    protected void register(DOMAIN domain) {
        if (!(getDao() instanceof Registerable)) {
            throw new UnsupportedOperationException(
                    "This register method must be overrided.");
        }
        ((Registerable<DOMAIN>) getDao()).register(domain);
    }

    /**
     * hCIuWFNg擾܂Bf[^ANZXIuWFNgA{@link SimpleFindable} 
     * Ă邱ƂOƂĂ܂BKvɉăTuNXŃI[o[ChĂB
     *
     * @param id ID
     * @return hCIuWFNg
     */
    protected DOMAIN find(int id) {
        if (!(getDao() instanceof SimpleFindable)) {
            throw new UnsupportedOperationException(
                    "This find method must be overrided.");
        }
        return ((SimpleFindable<DOMAIN>) getDao()).find(id);
    }

    /**
     * hCIuWFNgXV܂Bf[^ANZXIuWFNgA{@link Updatable} Ă邱
     * ƂOƂĂ܂BKvɉăTuNXŃI[o[ChĂB
     *
     * @param domain hCIuWFNg
     */
    protected void update(DOMAIN domain) {
        if (!(getDao() instanceof Updatable)) {
            throw new UnsupportedOperationException(
                    "This update method must be overrided.");
        }
        ((Updatable<DOMAIN>) getDao()).update(domain);
    }

    /**
     * hCIuWFNg폜܂Bf[^ANZXIuWFNgA{@link SimpleDeletable} 
     * Ă邱ƂOƂĂ܂BKvɉăTuNXŃI[o[ChĂB
     *
     * @param id ID
     */
    protected void delete(int id) {
        if (!(getDao() instanceof SimpleDeletable)) {
            throw new UnsupportedOperationException(
                    "This delete method must be overrided.");
        }
        ((SimpleDeletable) getDao()).delete(id);
    }

    private int getId(DOMAIN domain) {
        return (Integer) PropertyUtils.getProperty(domain,
                getPrimaryKeyPropertyName());
    }
}
