package org.unitedfront2.domain.communication;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import org.junit.Assert;
import org.junit.Test;
import org.unitedfront2.domain.accesscontrol.AccessControl;
import org.unitedfront2.domain.accesscontrol.OwnerOnly;
import org.unitedfront2.domain.accesscontrol.Public;
import org.unitedfront2.domain.accesscontrol.UserOnly;
import org.unitedfront2.test.TransactionalTestCaseWithInitialData;

public class BlogEntryTest extends TransactionalTestCaseWithInitialData {

    @Test
    public void testPost() throws BlogCodeUsedByOtherException {
        AccessControl readAccessControl = domainFactory.prototype(Public.class);
        AccessControl writeAccessControl = domainFactory.prototype(OwnerOnly.class);
        Blog blog = domainFactory.prototype(new Blog("test",
                createOverview(readAccessControl, writeAccessControl),
                simpleUser1.getId(), readAccessControl, writeAccessControl,
                domainFactory.prototype(UserOnly.class)), Blog.class);
        blog.store();
        BlogEntry blogEntry = domainFactory.prototype(new BlogEntry(createEntry(
                blog.getReadAccessControl(), blog.getWriteAccessControl())), BlogEntry.class);
        blog.post(blogEntry);
        Comment comment = createComment();

        Assert.assertSame(0, domainFactory.prototype(blogEntry).getComments().size());
        blogEntry.post(comment);
        Assert.assertSame(1, domainFactory.prototype(blogEntry).getComments().size());
        Assert.assertEquals(comment, blogEntry.getComments().get(0));
    }

    private Message createOverview(AccessControl readAccessControl,
            AccessControl writeAccessControl) {
        MessageEntry entry = new MessageEntry();
        entry.setSubject("eXguO");
        entry.setBody("̓eXguOłB");
        Map<Locale, MessageEntry> entryMap
            = new HashMap<Locale, MessageEntry>();
        entryMap.put(Locale.JAPANESE, entry);
        Message overview = domainFactory.prototype(new Message(null, entryMap,
                simpleUser1.getId(), simpleUser1.getId(),
                readAccessControl, writeAccessControl), Message.class);
        return overview;
    }

    private Message createEntry(AccessControl readAccessControl,
            AccessControl writeAccessControl) {
        MessageEntry entry = new MessageEntry();
        entry.setSubject("̋LłB");
        entry.setBody("͍̋LłB");
        Map<Locale, MessageEntry> entryMap = new HashMap<Locale, MessageEntry>();
        entryMap.put(Locale.JAPANESE, entry);
        Message article = domainFactory.prototype(new Message(null, entryMap,
                simpleUser1.getId(), simpleUser1.getId(),
                readAccessControl, writeAccessControl), Message.class);
        return article;
    }

    private Comment createComment() {
        return domainFactory.prototype(new Comment(simpleUser1.getId(),
                "̓Rg̃eXgłB"), Comment.class);
    }
}
