package org.unitedfront2.domain.accesscontrol;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.test.TransactionalTestCase;

public class AccessControlTableTest extends TransactionalTestCase {

    @Autowired private AccessControlTable accessControlTable;

    @Test
    public void testFind() {
        AccessControl accessControl = domainFactory.prototype(Public.class);
        accessControl.store();
        AccessControl foundAccessControl = accessControlTable.find(accessControl.getId());
        Assert.assertEquals(accessControl, foundAccessControl);
    }

    @Test
    public void testFindȂ() {
       Assert.assertNull(accessControlTable.find(-1));
    }

    @Test
    public void testExist() {
        AccessControl accessControl = domainFactory.prototype(Public.class);
        accessControl.store();
        Assert.assertNotNull(accessControlTable.find(accessControl.getId()));
    }

    @Test
    public void testExistȂ() {
        Assert.assertNull(accessControlTable.find(-1));
    }

    @Test
    public void testPrototypeType() {
        AccessControl accessControl = domainFactory.prototype(Public.class);
        Assert.assertEquals(new Public(), accessControl);
    }
}
