package org.unitedfront2.domain;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.dao.DateDao;
import org.unitedfront2.domain.SampleDomain.State;
import org.unitedfront2.test.TransactionalTestCase;

public class SampleDomainTest extends TransactionalTestCase {

    @Autowired
    private SampleDomainTable sampleDomainTable;

    @Autowired
    private DateDao dateDao;

    @Test
    public void testMultipleTextLengthAndD() {
        SampleDomain sampleDomain = createDomain();
        Assert.assertEquals(12.5, sampleDomain.multipleTextLengthAndD(), 0.01);
    }

    @Test
    public void testStoreo^() throws DuplicateSampleDomainCodeException {
        SampleDomain sampleDomain = createDomain();
        sampleDomain.store();
        SampleDomain found = sampleDomainTable.find(sampleDomain.getId());
        Assert.assertEquals(sampleDomain, found);
    }

    @Test(expected=DuplicateSampleDomainCodeException.class)
    public void testStoreo^݂邪R[h݂() throws DuplicateSampleDomainCodeException {
        SampleDomain sampleDomain = createDomain();
        sampleDomain.store();
        SampleDomain sampleDomain2 = domainFactory.prototype(sampleDomain, SampleDomain.class);
        sampleDomain2.setId(null);
        sampleDomain2.store();
    }

    @Test
    public void testStoreXV() throws DuplicateSampleDomainCodeException {
        SampleDomain sampleDomain = createDomain();
        sampleDomain.store();
        sampleDomain.setCode("new_" + sampleDomain.getCode());
        sampleDomain.setText("new_" + sampleDomain.getText());
        sampleDomain.setState(State.DISABLE);
        sampleDomain.store();
        SampleDomain found = sampleDomainTable.find(sampleDomain.getId());
        Assert.assertEquals(sampleDomain, found);
    }

    @Test(expected=DuplicateSampleDomainCodeException.class)
    public void testStoreXV݂邪R[h݂() throws DuplicateSampleDomainCodeException {
        SampleDomain sampleDomain = createDomain();
        sampleDomain.store();
        SampleDomain sampleDomain2 = domainFactory.prototype(sampleDomain, SampleDomain.class);
        sampleDomain2.setId(null);
        sampleDomain2.setCode("new_" + sampleDomain2.getCode());
        sampleDomain2.store();
        sampleDomain2.setCode(sampleDomain.getCode());
        sampleDomain2.store();
    }

    private SampleDomain createDomain() {
        return domainFactory.prototype(new SampleDomain("test", 2.5, "text.", false, dateDao.getCurrentDate(), State.AVAILABLE), SampleDomain.class);
    }
}
