package org.unitedfront2.domain;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.dao.DateDao;
import org.unitedfront2.domain.SampleDomain.State;
import org.unitedfront2.test.TransactionalTestCase;

public class SampleDomainTableTest extends TransactionalTestCase {

    @Autowired
    private SampleDomainTable sampleDomainTable;

    @Autowired
    private DateDao dateDao;

    @Test
    public void testFind() throws DuplicateSampleDomainCodeException {
        SampleDomain sample = createDomain();
        sample.store();
        SampleDomain found = sampleDomainTable.find(sample.getId());
        Assert.assertEquals(sample, found);
    }

    @Test
    public void testFindȂ() {
        Assert.assertNull(sampleDomainTable.find(-1));
    }

    private SampleDomain createDomain() {
        return domainFactory.prototype(new SampleDomain("test", 2.5, "text.", false, dateDao.getCurrentDate(), State.AVAILABLE), SampleDomain.class);
    }
}
