package org.unitedfront2.domain;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitedfront2.dao.SampleDomainDao;

public class SampleDomainTable {

    /** O */
    protected final Log logger = LogFactory.getLog(getClass());

    /** TvhCf[^ANZXIuWFNg */
    private SampleDomainDao sampleDomainDao;

    /**
     * TvhC擾܂B
     *
     * @param id ID
     * @return TvhCAȂ <code>null</code>
     */
    public SampleDomain find(int id) {
        return sampleDomainDao.find(id);
    }

    /**
     * TvhC擾܂B
     *
     * @param code R[h
     * @return TvhCAȂ <code>null</code>
     */
    public SampleDomain findByCode(String code) {
        return sampleDomainDao.findByCode(code);
    }

    /**
     * TvhC擾܂B
     *
     * @param code R[h
     * @return TvhC
     * @throws IllegalArgumentException w肵R[hTvhC݂Ȃ
     */
    public SampleDomain getByCode(String code) throws IllegalArgumentException {
        SampleDomain sampleDomain = findByCode(code);
        if (sampleDomain == null) {
            String message = "The sample domain code '" + code + "' not found.";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        return sampleDomain;
    }

    /**
     * TvhC݂邩肵܂B
     *
     * @param code R[h
     * @return ݂Ȃ <code>true</code> A݂ȂȂ <code>false</code>
     */
    public boolean existByCode(String code) {
        return findByCode(code) != null;
    }

    /**
     * o^ĂTvhC̑擾܂B
     *
     * @return TvhC̑
     */
    public int count() {
        return sampleDomainDao.count();
    }

    public void setSampleDomainDao(SampleDomainDao sampleDomainDao) {
        this.sampleDomainDao = sampleDomainDao;
    }
}
