package org.unitedfront2.dao;

import java.util.Date;
import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.domain.Account;
import org.unitedfront2.domain.MailAddrUsedByOtherException;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.UserCodeUsedByOtherException;
import org.unitedfront2.domain.UserNameUsedByOtherException;
import org.unitedfront2.test.TransactionalTestCaseWithInitialData;

public class SimpleUserDaoTest extends TransactionalTestCaseWithInitialData {

    @Autowired private SimpleUserDao simpleUserDao;

    @Autowired private AccountDao accountDao;

    @Autowired
    private DateDao dateDao;

    @Test
    public void testFindLastAccessDate() {
        Assert.assertNotNull(simpleUserDao.find(simpleUser1.getId()));
    }

    @Test
    public void testFindByLastAccessDateAfter() throws InterruptedException {
        simpleUser1.touch();
        Thread.sleep(1000);
        Date date = dateDao.getCurrentDate();
        simpleUser2.touch();
        simpleUser3.touch();

        List<SimpleUser> users = simpleUserDao.findByLastAccessDateAfter(date);
        Assert.assertSame(2, users.size());
        Assert.assertTrue(SimpleUser.exists(users, simpleUser2));
        Assert.assertTrue(SimpleUser.exists(users, simpleUser3));
    }

    @Test
    public void testCountByLastAccessDateAfter() throws InterruptedException {
        simpleUser1.touch();
        Thread.sleep(1000);
        Date date = dateDao.getCurrentDate();
        simpleUser2.touch();
        simpleUser3.touch();

        int count = simpleUserDao.countByLastAccessDateAfter(date);
        Assert.assertSame(2, count);
    }

    @Test
    public void testRegister() throws MailAddrUsedByOtherException, UserCodeUsedByOtherException, UserNameUsedByOtherException {
        Account account12 = domainFactory.prototype(account1, Account.class);
        account12.setId(null);
        account12.setMailAddr(account1.getMailAddr() + "2");
        accountDao.register(account12);
        SimpleUser user2 = new SimpleUser();
        user2.setId(account12.getId());
        user2.setCode("usercode2");
        user2.setName("[U2");
        simpleUserDao.register(user2);
        SimpleUser found = simpleUserDao.find(user2.getId());
        Assert.assertEquals(user2, found);
        Assert.assertNull(found.getLastAccessDate());
    }

    @Test
    public void testUpdate() throws UserCodeUsedByOtherException, UserNameUsedByOtherException {
        SimpleUser newUser = domainFactory.prototype(simpleUser1, SimpleUser.class);
        newUser.setCode("new_" + simpleUser1.getCode());
        simpleUserDao.update(newUser);
        User foundUser = simpleUserDao.find(newUser.getId());
        Assert.assertEquals(newUser, foundUser);
    }

    @Test
    public void testFindByCode() {
        Assert.assertEquals(simpleUser1, simpleUserDao.findByCode(simpleUser1.getCode()));
    }

    @Test
    public void testFindByCodeȂ() {
        Assert.assertNull(simpleUserDao.findByCode("______"));
    }

    @Test
    public void testFindByName() {
        Assert.assertEquals(simpleUser1, simpleUserDao.findByName(simpleUser1.getName()));
    }

    @Test
    public void testFindByNameȂ() {
        Assert.assertNull(simpleUserDao.findByName("_____"));
    }

    @Test
    public void testUpdateLastAccessDate() {
        Date lastAccessDate = simpleUserDao.findLastAccessDate(simpleUser1.getId());

        simpleUserDao.updateLastAccessDate(simpleUser1.getId(), dateDao.getCurrentDate());
        Date found = simpleUserDao.findLastAccessDate(simpleUser1.getId());
        Assert.assertNotSame(lastAccessDate, found);
    }
}
