package org.unitedfront2.dao;

import java.util.Calendar;
import java.util.Date;

import org.apache.commons.lang.time.DateUtils;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.domain.SampleDomain;
import org.unitedfront2.domain.SampleDomain.State;
import org.unitedfront2.test.DaoTestCaseSupport;

public class SampleDomainDaoTest extends DaoTestCaseSupport<SampleDomain> {

    @Autowired private SampleDomainDao sampleDomainDao;

    @Override
    protected void editTestDomain(SampleDomain sampleDomain) {
        sampleDomain.setText("new_" + sampleDomain.getText());
        sampleDomain.setState(State.DISABLE);
    }

    @Override
    protected SampleDomain createTestDomain() {
        SampleDomain sampleDomain = new SampleDomain();
        sampleDomain.setCode("test");
        sampleDomain.setD(12.345);
        sampleDomain.setText("This is Example text.");
        sampleDomain.setBool(false);
        sampleDomain.setDate(new java.sql.Timestamp(DateUtils.truncate(new Date(), Calendar.SECOND).getTime()));
        sampleDomain.setState(State.AVAILABLE);
        return sampleDomain;
    }

    @Override
    protected SimpleFindable<SampleDomain> getDao() {
        return sampleDomainDao;
    }

    @Test
    public void testFindByCode() {
        SampleDomain expected = createTestDomain();
        sampleDomainDao.register(expected);

        SampleDomain actual = sampleDomainDao.findByCode(expected.getCode());
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void testFindByCodeȂ() {
        Assert.assertNull(sampleDomainDao.findByCode("---"));
    }

    @Test
    public void testCount() {
        SampleDomain sd1 = createTestDomain();
        sampleDomainDao.register(sd1);
        SampleDomain sd2 = createTestDomain();
        sd2.setCode(sd2.getCode() + "2");
        sampleDomainDao.register(sd2);
        int count = sampleDomainDao.count();
        Assert.assertEquals(2, count);
    }
}
