package org.unitedfront2.dao;

import java.util.List;

import javax.annotation.Resource;

import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.domain.Installer;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.accesscontrol.AccessControl;
import org.unitedfront2.domain.accesscontrol.FriendOnly;
import org.unitedfront2.domain.accesscontrol.OwnerOnly;
import org.unitedfront2.domain.accesscontrol.Public;
import org.unitedfront2.domain.communication.Profile;
import org.unitedfront2.test.DaoTestCaseSupport;

public class ProfileDaoTest extends DaoTestCaseSupport<Profile> {

    @Autowired private ProfileDao profileDao;

    @Resource(name = "profileTable")
    private Installer profileInstaller;

    @Override
    protected Profile createTestDomain() {
        Profile profile = new Profile();
        profile.setOwnerId(simpleUser1.getId());
        profile.setReadAccessControl(domainFactory.prototype(Public.class));
        profile.setWriteAccessControl(domainFactory.prototype(OwnerOnly.class));
        return profile;
    }

    @Override
    protected void editTestDomain(Profile profile) {
        profile.getReadAccessControl().changeTo(FriendOnly.class);
    }

    @Override
    protected Object getDao() {
        return profileDao;
    }

    @Override
    protected String getPrimaryKeyPropertyName() {
        return "ownerId";
    }

    @Test
    public void testFindByOwnerCode() {
        Profile profile = createTestDomain();
        profileDao.register(profile);

        Profile expected = profileDao.find(simpleUser1.getId());
        Profile actual = profileDao.findByOwnerCode(simpleUser1.getCode());
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void testFindPublicProfileOwners() {
        profileInstaller.install(simpleUser1.getId());
        profileInstaller.install(simpleUser2.getId());
        profileInstaller.install(simpleUser3.getId());

        List<SimpleUser> users = profileDao.findPublicProfileOwnersRandomly();
        Assert.assertEquals(3, users.size());
        for (SimpleUser user : users) {
            Assert.assertEquals(profileDao.find(user.getId()).getReadAccessControl().getType(), Public.class);
        }
    }

    @Test
    public void testFindPublicProfileOwnersRandomlyΏېő匏葽() {
        profileInstaller.install(simpleUser1.getId());
        profileInstaller.install(simpleUser2.getId());
        profileInstaller.install(simpleUser3.getId());

        List<SimpleUser> users = profileDao.findPublicProfileOwnersRandomly(2);
        Assert.assertEquals(2, users.size());
        for (SimpleUser user : users) {
            Assert.assertEquals(profileDao.find(user.getId()).getReadAccessControl().getType(), Public.class);
        }
    }

    @Test
    public void testFindPublicProfileOwnersRandomlyΏېő匏菭Ȃ() {
        profileInstaller.install(simpleUser1.getId());
        profileInstaller.install(simpleUser2.getId());
        profileInstaller.install(simpleUser3.getId());

        List<SimpleUser> users = profileDao.findPublicProfileOwnersRandomly(4);
        Assert.assertEquals(3, users.size());
        for (SimpleUser user : users) {
            Assert.assertEquals(profileDao.find(user.getId()).getReadAccessControl().getType(), Public.class);
        }
    }

    @Test
    public void testFindPublicProfileOwnersJĂȂ͎̂擾łȂ() {
        profileInstaller.install(simpleUser1.getId());
        profileInstaller.install(simpleUser2.getId());
        profileInstaller.install(simpleUser3.getId());

        Profile profile = profileDao.find(simpleUser1.getId());
        profile.getReadAccessControl().changeTo(OwnerOnly.class);
        profile.getReadAccessControl().store();
        List<SimpleUser> users = profileDao.findPublicProfileOwnersRandomly();
        Assert.assertEquals(2, users.size());
        for (SimpleUser user : users) {
            Assert.assertEquals(profileDao.find(user.getId()).getReadAccessControl().getType(), Public.class);
        }
    }

    @Test
    public void testFindReadAccessControl() {
        profileInstaller.install(simpleUser1.getId());

        AccessControl readAccessControl = profileDao.findReadAccessControl(simpleUser1.getId());
        Assert.assertEquals(profileDao.find(simpleUser1.getId()).getReadAccessControl(), readAccessControl);
    }

    @Test
    public void testFindReadAccessControlȂ() {
        Assert.assertNull(profileDao.findReadAccessControl(-1));
    }

    @Override
    @Ignore
    public void testDelete() {
        // ignore
    }
}
