package org.unitedfront2.dao;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Map.Entry;

import javax.annotation.Resource;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.domain.accesscontrol.AuthorOnly;
import org.unitedfront2.domain.accesscontrol.Public;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.domain.communication.MessageCodeUsedByOtherException;
import org.unitedfront2.domain.communication.MessageEntry;
import org.unitedfront2.test.DaoTestCaseSupport;

public class MessageDaoTest extends DaoTestCaseSupport<Message> {

    @Autowired private MessageDao messageDao;

    @Autowired
    private DateDao dateDao;

    @Resource(name = "availableLocales")
    private List<Locale> availableLocales;

    @Override
    protected Message createTestDomain() {
        Message message = new Message();
        message.setAvailableLocales(availableLocales);
        message.setCode(RandomStringUtils.randomAlphanumeric(16).toLowerCase());
        message.setAuthorId(simpleUser1.getId());
        Map<Locale, MessageEntry> entryMap = new HashMap<Locale, MessageEntry>();
        MessageEntry entry_ja = new MessageEntry();
        entry_ja.setSubject("Tv^Cg");
        entry_ja.setBody("Tv{");
        MessageEntry entry_en = new MessageEntry();
        entry_en.setSubject("sample title");
        entry_en.setBody("sample body");
        entryMap.put(Locale.JAPANESE, entry_ja);
        message.setEntryMap(entryMap);
        message.setOwnerId(simpleUser1.getId());
        message.setReadAccessControl(domainFactory.prototype(Public.class));
        message.setWriteAccessControl(domainFactory.prototype(AuthorOnly.class));
        message.setMessageDao(messageDao);
        message.setLastUpdateDate(dateDao.getCurrentDate());
        message.setRegistrationDate(dateDao.getCurrentDate());
        return message;
    }

    @Override
    protected void editTestDomain(Message message) {
        for (Entry<Locale, MessageEntry> entry : message.getEntryMap().entrySet()) {
            entry.getValue().setSubject("new_" + entry.getValue().getSubject());
            entry.getValue().setBody("new_" + entry.getValue().getBody());
        }
    }

    @Override
    protected SimpleFindable<Message> getDao() {
        return messageDao;
    }

    @Test
    @Override
    public void testFindFound() throws MessageCodeUsedByOtherException {
        Message expected = createTestDomain();
        messageDao.register(expected);

        Message actual = messageDao.find(expected.getId());
        Assert.assertEquals(expected, actual);
        for (Locale locale : availableLocales) {
            Assert.assertNotNull(actual.getEntryMap().get(locale));
        }
    }

    @Test
    public void testFindByCode() throws MessageCodeUsedByOtherException {
        Message expected = createTestDomain();
        messageDao.register(expected);

        Message actual = messageDao.findByCode(expected.getCode());
        Assert.assertEquals(expected, actual);
        for (Locale locale : availableLocales) {
            Assert.assertNotNull(expected.getEntryMap().get(locale));
        }
    }

    @Test
    public void testFindByCodeȂ() {
        Assert.assertNull(messageDao.findByCode("_____"));
    }
}
