<%@ page language="java" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/view/Include.jsp" %>

<%-- dojo の不具合に対応するための処理が加わっている --%>
<%-- dojo 1.0 からは name が entryMap['ja'].body となるフォーム DOM が消えてしまう--%>
<uf2:script>
function doSubmitMessageForm(form) {
    form.disabled='disabled';
    <c:forEach var="l" items="${_availableLocales}">
      <c:if test="${l.language == 'ja'}">
    if (document.getElementById('f2_subject_${l.language}')) {
        document.getElementById('f2_subject_${l.language}').value = document.getElementById('f1_subject_${l.language}').value;
    }
    document.getElementById('f2_body_${l.language}').value = dijit.byId('f1_body_${l.language}').getValue();
      </c:if>
    </c:forEach>
    document.forms['messageForm'].submit();
    return false;
}
</uf2:script>
<div>
  <h2><spring:message code="${pageTitleCode}"/></h2>
  <c:if test="${not empty pageDescriptionCode}">
    <p><spring:message code="${pageDescriptionCode}"/></p>
  </c:if>
  <uf2:pc>
  <form:form commandName="message" onsubmit="return doSubmitMessageForm(this);">
    <spring:hasBindErrors name="message">
    <div class="error">
      <spring:message code="MessageForm.error"/><br/>
      <form:errors/>
    </div>
    </spring:hasBindErrors>
    <c:forEach var="l" items="${_availableLocales}">
      <c:if test="${l.language == 'ja'}">
        <c:if test="${!subjectDisabled}">
          <div class="element">
            <spring:message code="subject"/><small> [<spring:message code="language.${l.language}"/>]</small>:
            <form:errors path="entryMap['${l.language}'].subject" cssClass="errors"/><br/>
            <input type="text" id="f1_subject_${l.language}" name="entryMap['${l.language}'].subject" value="<c:out value="${message.entryMap[l].subject}"/>" size="30" maxlength="${validator.subjectMaxLength}"/>
            ( <spring:message code="validation.Validate.maxLength" arguments="${validator.subjectMaxLength}"/> )
          </div>
        </c:if>
        <div class="element <spring:theme code="dojo.theme"/>">
          <spring:message code="body"/><small> [<spring:message code="language.${l.language}"/>]</small>:
          <form:errors path="entryMap['${l.language}'].body" cssClass="errors"/>
          <div class="editingArea">
            <textarea id="f1_body_${l.language}" name="entryMap['${l.language}'].body" cols="40" rows="5" dojoType="dijit.Editor" plugins="['undo', 'redo', '|', 'bold', 'italic', 'underline', 'strikethrough', '|', 'insertOrderedList', 'insertUnorderedList', '|', 'justifyLeft', 'justifyCenter', 'justifyRight', '|', 'dijit._editor.plugins.LinkDialog']" height="240">${message.entryMap[l].body}</textarea>
          </div>
        </div>
      </c:if>
    </c:forEach>
    <div class="element"><input type="submit" value="<spring:message code="${formSubmitCode}"/>" class="button"/></div>
  </form:form>
  <form action="" method="post" name="messageForm">
    <input type="hidden" name="_eventId" value="submit"/>
    <input type="hidden" name="_flowExecutionKey" value="${flowExecutionKey}"/>
    <c:forEach var="l" items="${_availableLocales}">
    <c:if test="${!subjectDisabled}">
      <input type="hidden" id="f2_subject_${l.language}" name="entryMap['${l.language}'].subject" value=""/>
    </c:if>
    <input type="hidden" id="f2_body_${l.language}" name="entryMap['${l.language}'].body" value=""/>
    </c:forEach>
  </form>
  <c:if test="${!subjectDisabled}">
  <uf2:script>
  document.getElementById('f1_subject_${_locale.language}').focus();
  </uf2:script>
  </c:if>
  </uf2:pc>
  <uf2:mobile>
  <form:form commandName="message">
    <input type="hidden" name="_eventId" value="submit"/>
    <input type="hidden" name="_flowExecutionKey" value="${flowExecutionKey}"/>
    <div>
      <c:forEach var="l" items="${_availableLocales}">
      <div>
        <c:if test="${!subjectDisabled}">
        <div class="element">
          <spring:message code="subject"/><small> [<spring:message code="language.${l.language}"/>]</small>: <form:errors path="entryMap['${l.language}'].subject" cssClass="errors"/><br/>
          <input type="text" id="f1_subject_${l.language}" name="entryMap['${l.language}'].subject" value="<c:out value="${message.entryMap[l].subject}"/>" size="30" maxlength="${validator.subjectMaxLength}"/> ( <spring:message code="validation.Validate.maxLength" arguments="${validator.subjectMaxLength}"/> )
        </div>
        </c:if>
        <div class="element">
          <spring:message code="body"/><small> [<spring:message code="language.${l.language}"/>]</small>: <form:errors path="entryMap['${l.language}'].body" cssClass="errors"/><br/>
          <textarea name="entryMap['${l.language}'].body" cols="40" rows="5">${message.entryMap[l].body}</textarea>
        </div>
      </div>
      </c:forEach>
    </div>
    <div class="element"><input type="submit" value="<spring:message code="${formSubmitCode}"/>" class="button"/></div>
  </form:form>
  </uf2:mobile>
</div>