<%@ page language="java" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/view/Include.jsp" %>

<uf2:script>
  function enableReplyForm() {
    dojo.removeClass(dojo.byId('mail.ReplyForm'), 'disabled');
    dojo.byId('mail.ReplyForm.body').focus();
    dojo.addClass(dojo.byId('mail.ReplyLink'), 'disabled');
  }
</uf2:script>

<div>

  <!-- Status Bar -->
  <div id="statusBar">
    <spring:message code="mail"/>
  </div>

  <h2><c:out value="${thread.subject}"/></h2>
  <div>
    <uf2:pc>
      <c:if test="${not empty thread.from}">
    <div id="mail.ReplyLink" class="float-left">
      <a href="javascript:enableReplyForm();"><spring:message code="mail.ViewAndReply.reply"/></a>
    </div>
      </c:if>
    </uf2:pc>
    <div class="float-right">
      <a href="<c:url value="/mail/"/>"><spring:message code="mail.toIndex"/></a>
    </div>
  </div>
  <div class="float-clear"></div>
  <c:if test="${not empty thread.from}">
  <div id="mail.ReplyForm" class="margin<uf2:pc> disabled</uf2:pc>">
    <h3><spring:message code="mail.ViewAndReply.replyForm"/></h3>
    <form:form commandName="mail">
      <input type="hidden" name="_eventId" value="submit"/>
      <input type="hidden" name="_flowExecutionKey" value="${flowExecutionKey}"/>
      <div class="element">
        <spring:message code="body"/>: <form:errors path="body" cssClass="errors"/><br/>
        <form:textarea path="body" rows="5" cols="40" id="mail.ReplyForm.body"/>
      </div>
      <div class="element">
        <input type="submit" value="<spring:message code="mail.ViewAndReply.submit"/>" class="button" onclick="this.disabled='disabled';this.form.submit();"/>
      </div>
    </form:form>
  </div>
  </c:if>
  <div>
    <uf2:forEachMail var="mail" mail="${thread}">
    <div class="radius border padding margin-top">
      <div class="smaller thin"><uf2:formatDate date="${mail.sentDate}" detail="true"/></div>
      <p><uf2:multiLine value="${mail.body}"/></p>
      <div class="align-right smaller"><spring:message code="by"/>&nbsp;
        <c:if test="${canReadProfile}">
          <uf2:user user="${mail.from}" link="true"/>
        </c:if>
        <c:if test="${!canReadProfile}">
          <uf2:user user="${mail.from}" link="false"/>
        </c:if>
      </div>
    </div>
    </uf2:forEachMail>
  </div>
</div>

<uf2:script>
  <spring:hasBindErrors name="mail">enableReplyForm();</spring:hasBindErrors>
</uf2:script>
