<%@ page language="java" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/view/Include.jsp" %>
<div>

  <!-- Status Bar -->
  <div id="statusBar">
    <spring:message code="community"/> &gt; <spring:message code="community.type.MultiThreadCommunity"/> &gt; <spring:message code="thread"/>
  </div>

  <h3><a href="<c:url value="/community/${community.code}/index.html"/>"><uf2:messageSubject message="${community.overview}"/></a></h3>

  <%@ include file="ThreadOverview.jsp" %>

  <!-- Entries -->
  <c:if test="${thread.status == 'AVAILABLE'}">
    <div class="margin-bottom align-center">
      <uf2:canPost community="${community}" user="${_user}">
        <a href="<c:url value="/community/${community.code}/${thread.id}/post.html"/>"><spring:message code="doPost"/></a>
      </uf2:canPost>
    </div>
  </c:if>
  <div>
    <c:forEach var="entry" items="${thread.entries}">
      <!-- Entry -->
      <div class="margin-top">
        <%@ include file="EntryViewTarget.jsp" %>
      </div>
    </c:forEach>
  </div>
  <div class="margin-top">
    <uf2:paging count="${thread.count}" url="/community/${community.code}/${thread.id}/index.html" displayCount="${displayCount}"/>
  </div>

  <%@ include file="ThreadSubMenu.jsp" %>

  <%@ include file="ThreadAccessControl.jsp" %>

</div>
