<%@ page language="java" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/view/Include.jsp" %>
<div>

  <!-- Status Bar -->
  <div id="statusBar">
    <spring:message code="blog"/> &gt; <spring:message code="blog.EntryIndex"/>
  </div>

  <!-- Overview -->
  <h2><uf2:messageSubject message="${blog.overview}"/></h2>
  <p><uf2:messageBody message="${blog.overview}"/></p>
  <div class="align-right smaller">
    <spring:message code="by"/>&nbsp;<uf2:user user="${blog.owner}"/>
  </div>

  <!-- Entries -->
  <div class="align-center">
    <uf2:identity o2="${blog.owner}" o1="${_user}">
      <a href="<c:url value="/blog/${blog.code}/post.html"/>"><spring:message code="blog.View.postLink"/></a>
    </uf2:identity>
  </div>
  <div>
    <c:forEach var="entry" items="${blog.entries}">
    <!-- Entry -->
    <div>
      <div class="smaller thin"><uf2:formatDate date="${entry.registrationDate}" detail="true"/></div>
      <h3 class="underline"><a href="<c:url value="/blog/${blog.code}/entry-${entry.code}.html"/>"><uf2:messageSubject message="${entry.entry}"/></a></h3>
      <p><uf2:messageBody message="${entry.entry}"/></p>
      <div class="align-right smaller">
        <a href="<c:url value="/blog/${blog.code}/entry-${entry.code}.html#comment"/>"><spring:message code="comment"/> (${entry.commentCount})</a>
      </div>
    </div>
    </c:forEach>
  </div>
  <div class="margin-top">
    <uf2:paging count="${blog.count}" url="/blog/${blog.code}/index.html" displayCount="${displayCount}"/>
    <div class="align-center">
      <c:if test="${blog.count > 0}">
        <a href="<c:url value="/blog/${blog.code}/indexAll.html"/>"><spring:message code="blog.View.entryIndexLink"/></a>
      </c:if>
    </div>
  </div>

  <uf2:identity o2="${blog.owner}" o1="${_user}">
  <!-- Owner's menu -->
  <div class="margin-top">
    <div class="align-right">
      <a href="<c:url value="/blog/${blog.code}/update.html"/>"><spring:message code="blog.View.overviewEditLink"/></a>
    </div>
    <form action="<c:url value="/blog/delete.html"/>" method="post" onsubmit="return confirm('<spring:message code="blog.View.deleteLink.confirm"/>');" class="align-right">
      <input type="hidden" name="blogCode" value="${blog.code}"/>
      <input type="submit" name="" value="<spring:message code="blog.View.deleteLink"/>" <c:if test="${blog.count > 0}">title="<spring:message code="blog.View.deleteLink.disabled.comment"/>" disabled="disabled"</c:if>/>
    </form>
  </div>
  </uf2:identity>

  <!-- Access Control -->
  <div>
    <h3><spring:message code="accesscontrol.authority"/></h3>
    <table border="1" class="margin smaller">
      <tr>
        <th><spring:message code="accesscontrol.authority.read"/></th>
        <td><spring:message code="accesscontrol.type.${blog.readAccessControl.type.simpleName}"/></td>
      </tr>
      <tr>
        <th><spring:message code="accesscontrol.authority.write"/></th>
        <td><spring:message code="accesscontrol.type.${blog.writeAccessControl.type.simpleName}"/></td>
      </tr>
      <tr>
        <th><spring:message code="blog.authority.commentPost"/></th>
        <td><spring:message code="accesscontrol.type.${blog.commentAccessControl.type.simpleName}"/></td>
      </tr>
    </table>
  </div>

</div>
