package org.unitedfront2.web.validator;

import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.validation.ValidationContext;
import org.unitedfront2.domain.communication.Mail;
import org.unitedfront2.validation.ValidationException;

/**
 * {@link Mail} p̃of[^NXłB
 *
 * @author kurokkie
 *
 */
public class MailValidator extends
        org.unitedfront2.domain.communication.MailValidator {

    /** VAԍ */
    private static final long serialVersionUID = 2111577288272621045L;

    public void validateCreateForm(Mail mail, ValidationContext context) {
        try {
            validateSubject(mail);
        } catch (ValidationException e) {
            context.getMessageContext().addMessage(new MessageBuilder().error()
                    .source("subject").code(e.getCode()).args(e.getArguments())
                    .build());
        }
    }
}
