package org.unitedfront2.web.validator;

import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.validation.ValidationContext;
import org.unitedfront2.domain.communication.Community;
import org.unitedfront2.validation.ValidationException;

/**
 * {@link Community} p̃of[^NXłB
 *
 * @author kurokkie
 *
 */
public class CommunityValidator extends
        org.unitedfront2.domain.communication.CommunityValidator {

    /** VAԍ */
    private static final long serialVersionUID = 2232742528065527039L;

    public void validateCodeForm(Community cocmmunity,
            ValidationContext context) {
        try {
            validateCode(cocmmunity);
        } catch (ValidationException e) {
            context.getMessageContext().addMessage(new MessageBuilder().error()
                    .source("code").code(e.getCode()).args(e.getArguments())
                    .build());
        }
    }
}
