package org.unitedfront2.web.validator;

import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.validation.ValidationContext;
import org.unitedfront2.domain.communication.Blog;
import org.unitedfront2.validation.ValidationException;

/**
 * {@link Blog} p̃of[^NXłB
 *
 * @author kurokkie
 *
 */
public class BlogValidator extends
        org.unitedfront2.domain.communication.BlogValidator {

    /** VAԍ */
    private static final long serialVersionUID = 2232742528065527039L;

    public void validateCodeForm(Blog blog, ValidationContext context) {
        try {
            validateCode(blog);
        } catch (ValidationException e) {
            context.getMessageContext().addMessage(new MessageBuilder().error()
                    .source("code").code(e.getCode()).args(e.getArguments())
                    .build());
        }
    }
}
