package org.unitedfront2.web.flow;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.springframework.web.util.WebUtils;
import org.springframework.webflow.context.servlet.DefaultFlowUrlHandler;
import org.unitedfront2.web.AccessDeniedException;

/**
 * URI t[ ID 𐶐悤Ɋg {@link DefaultFlowUrlHandler} łB
 *
 * @author kurokkie
 *
 */
public class FlowUrlHandler extends DefaultFlowUrlHandler {

    /** ftHg̃t[ID̐ڔ */
    public static final String DEFAULT_FLOW_ID_SUFFIX = "-flow";

    /** ftHg̃CfbNXt[ID */
    public static final String DEFAULT_INDEX_FLOW_ID = "index";

    /** _ URL i[p[^ (logicalUrl) */
    public static final String LOGICAL_URL_PARAM_NAME = "logicalUrl";

    /** t[ID̐ڔ */
    private String flowIdSuffix = DEFAULT_FLOW_ID_SUFFIX;

    /** CfbNXt[ID */
    private String indexFlowId = DEFAULT_INDEX_FLOW_ID;

    /**
     * URI t[ ID 쐬܂B
     *
     * ɋL܂B
     * URI: /${context path}/dir1/dir2/page.html
     * t[ID̐ڔ: -flow
     * t[ID: dir1.dir2.page-flow
     *
     * @param request {@link HttpServletRequest}
     * @return t[ ID
     */
    @Override
    public String getFlowId(HttpServletRequest request) {
        String flowId = request.getRequestURI();
        if (flowId.endsWith("-sub.html")) {
            // Tut[ւ͒ڃANZXłȂ
            throw new AccessDeniedException("Access Denied to Sub Flow.");
        }
        flowId = flowId.substring(request.getContextPath().length());
        String fileName = WebUtils.extractFilenameFromUrlPath(flowId);
        if ("".equals(fileName)) {
            fileName = indexFlowId;
        }
        flowId = flowId.substring(0, flowId.lastIndexOf('/') + 1);
        flowId = flowId.concat(fileName);
        flowId = flowId.concat(flowIdSuffix);
        if (flowId.charAt(0) == '/') {
            flowId = flowId.substring(1);
        }
        flowId = flowId.replace('/', '.');
        return flowId;
    }

    /**
     * NGXgꂽ URL ̂܂ܕԂ悤ɏCB_CNg URL Lɂ邽߁B
     */
    @Override
    public String createFlowExecutionUrl(String flowId,
            String flowExecutionKey, HttpServletRequest request) {
        String logicalUrl = request.getParameter(LOGICAL_URL_PARAM_NAME);
        if (StringUtils.isNotEmpty(logicalUrl)) {
            return request.getContextPath() + logicalUrl + "?execution="
                + flowExecutionKey;
        } else {
            return super.createFlowExecutionUrl(flowId, flowExecutionKey,
                    request);
        }
    }
}
