package org.unitedfront2.web.controller.user;

import java.util.Date;

import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.preparer.PreparerException;
import org.apache.tiles.preparer.ViewPreparer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.unitedfront2.domain.SimpleUserTable;

/**
 * OC\EBWFbgp {@link ViewPreparer} łB
 *
 * @author kurokkie
 *
 */
@Repository(value = "userActiveUserCountWidgetPreparer")
public class ActiveUserCountWidgetPreparer implements ViewPreparer {

    /** 񂪍XVԊu (5) */
    public static final int REFLESH_TERM = 60 * 5 * 1000;

    /** OXV */
    private Date lastRefleshDate;

    /** OC̃LbV */
    private Integer cache;

    /** [Ue[u */
    @Autowired private SimpleUserTable simpleUserTable;

    @Override
    public void execute(TilesRequestContext tilesContext,
            AttributeContext attributeContext) throws PreparerException {
        attributeContext.putAttribute("activeUserCount",
                new Attribute(getActiveUserCount()));
    }

    private int getActiveUserCount() {
        if (cache == null
                || new Date().after(new Date(lastRefleshDate.getTime()
                        + REFLESH_TERM))) {
            cache = simpleUserTable.countActiveUser();
            lastRefleshDate = new Date();
        }
        return cache;
    }
}
