package org.unitedfront2.web.controller.profile;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.Account;
import org.unitedfront2.domain.DomainFactory;
import org.unitedfront2.domain.accesscontrol.AccessControl;
import org.unitedfront2.domain.communication.Profile;
import org.unitedfront2.domain.communication.ProfileTable;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.controller.SubflowUtils;

/**
 * ANZX̕ύXSANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "profileAccessControlUpdateAction")
public class AccessControlUpdateAction extends MultiAction {

    /** hCt@Ng */
    @Autowired
    private DomainFactory domainFactory;

    /** vtB[e[u */
    @Autowired
    private ProfileTable profileTable;

    /**
     * ݂̃ANZXt[XR[vɐݒ肵܂B
     *
     * @param context NGXgReLXg
     * @return Cxg
     */
    public Event init(RequestContext context) {
        Account account = WebUtils.findAccount(context);
        Profile profile = profileTable.find(account.getId());
        context.getFlowScope().put("profile", profile);
        context.getFlowScope().put(SubflowUtils.FORM_SUBMIT_CODE_PARAM_NAME,
                "doUpdate");
        return success();
    }

    /**
     * ANZXۑ܂B
     *
     * @param context NGXgReLXg
     * @return Cxg
     */
    public Event store(RequestContext context) {
        AccessControl accessControl = (AccessControl)
            context.getFlowScope().get("accessControl");
        accessControl = domainFactory.prototype(accessControl);
        accessControl.store();
        Profile profile = WebUtils.getDomain(context.getFlowScope(), "profile",
                Profile.class, domainFactory);
        context.getFlashScope().put("profile", profile);
        return success();
    }
}
