package org.unitedfront2.web.controller.message;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Repository;
import org.springframework.validation.DataBinder;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.controller.SubflowUtils;
import org.unitedfront2.web.flow.BadRequestException;

/**
 * bZ[W쐬/ҏWtH[̃ANVNXłBύX\Ȃ̂̓bZ[WGĝ݂̕łB
 *
 * @author kurokkie
 *
 */
@Repository(value = "messageFormAction")
public class FormAction extends org.unitedfront2.web.controller.FormAction {

    /** bZ[WR[h̕ϐ (message) */
    public static final String MESSAGE_PARAM_NAME = "message";

    /** K{Ƃ邩ǂi[ϐ (subjectRequired) */
    public static final String SUBJECT_REQUIRED_PARAM_NAME = "subjectRequired";

    /** \Ƃ邩ǂi[ϐ (subjectDisabled) */
    public static final String SUBJECT_DISABLED_PARAM_NAME = "subjectDisabled";

    @Override
    protected void initAction() {
        super.initAction();
        setFormObjectClass(Message.class);
    }

    @Override
    protected void initBinder(RequestContext context, DataBinder binder) {
        super.initBinder(context, binder);
        binder.setAllowedFields(new String[] {"entryMap*"});
    }

    @Override
    public Event setupForm(RequestContext context) throws Exception {
        Message message = WebUtils.findDomain(context.getFlowScope(),
                MESSAGE_PARAM_NAME, Message.class, domainFactory);
        if (message != null) {
            putFormObject(context, message);
        }
        SubflowUtils.setupMessages(context, "message.Form");
        context.getFlashScope().put(SUBJECT_DISABLED_PARAM_NAME,
                context.getFlowScope().get(SUBJECT_DISABLED_PARAM_NAME));
        return super.setupForm(context);
    }

    @Override
    protected void doValidate(RequestContext context, Object formObject,
            Errors errors) throws BadRequestException, Exception {
        super.doValidate(context, formObject, errors);
        Message message = (Message) formObject;
        Boolean subjectRequired = (Boolean) context.getFlowScope().get(
                SUBJECT_REQUIRED_PARAM_NAME);
        if (subjectRequired != null
                && StringUtils.isBlank(
                        message.getRequiredEntry().getSubject())) {
            errors.reject(
                    "message.FormAction.validation.subject.notBlank.error");
        }
    }

    @Override
    @Resource(name = "messageFormValidator")
    public void setValidator(Validator validator) {
        super.setValidator(validator);
    }
}
