package org.unitedfront2.web.controller.mail;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.Account;
import org.unitedfront2.domain.communication.Mail;
import org.unitedfront2.domain.communication.MailTable;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.flow.PageNotFoundException;

/**
 * [ꗗ\ANVłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "mailIndexAction")
public class IndexAction extends AbstractAction {

    /** Py[Wɕ\Xbh (15) */
    public static final int OFFSET = 15;

    /** [e[u */
    @Autowired private MailTable mailTable;

    /**
     * [ꗗ\܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     * @throws PageNotFoundException ݂Ȃy[WNGXgꂽ
     */
    @Override
    protected Event doExecute(RequestContext context)
        throws PageNotFoundException {

        Account account = WebUtils.findAccount(context);

        int page = context.getRequestParameters().getInteger("page", 0);
        List<Mail> mailList = mailTable.findThreads(account.getId(),
                page * OFFSET, OFFSET);
        int unreadMailCount = mailTable.countUnreadMail(account.getId());
        int count = mailTable.countThreads(account.getId());

        context.getFlashScope().put("mails", mailList);
        context.getFlashScope().put("count", count);
        context.getFlashScope().put("unreadMailCount", unreadMailCount);
        return success();
    }
}
