package org.unitedfront2.web.controller.community;

import org.springframework.stereotype.Repository;
import org.springframework.web.util.HtmlUtils;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.Community;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.handler.TitleInterceptor;

/**
 * R~jeB{ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "communityViewAction")
public class ViewAction extends MultiAction {

    /**
     * ^Cgݒ肵܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event putTitle(RequestContext context) {
        Community c = (Community) context.getFlowScope().getRequired(
                "community", Community.class);
        context.getFlashScope().put(
                TitleInterceptor.TITLE_CODE_PARAM_NAME, "community.View.title");
        context.getFlashScope().put(
                TitleInterceptor.TITLE_ARGS_PARAM_NAME,
                new Object[] {
                        HtmlUtils.htmlEscape(c.getOverview().getSubject(
                                WebUtils.getLocale(context))),
                });
        return success();
    }
}
