package org.unitedfront2.web.controller.community;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.Community;
import org.unitedfront2.domain.communication.CommunityTable;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.flow.PageNotFoundException;
import org.unitedfront2.web.tags.PagingTag;

/**
 * SẴR~jeBꗗ\ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "communityIndexAllAction")
public class IndexAllAction extends AbstractAction {

    /** y[Wɕ\R~jeB */
    public static final int DIAPLAY_COUNT = PagingTag.DEFAULT_DISPLAY_COUNT;

    /** R~jeBe[u */
    @Autowired
    private CommunityTable communityTable;

    @Override
    protected Event doExecute(RequestContext context) throws Exception {
        int page = context.getRequestParameters().getInteger(
                PagingTag.DEFAULT_PAGE_PARAM_NAME, 0);
        int currentPage = 0;
        int currentRow = 0;
        for (int i = page; i > 0; i--) {
            Integer cacheRow = context.getFlowScope().getInteger(
                    "page" + i + "-startRow");
            if (cacheRow != null) {
                // LbV݂
                if (logger.isDebugEnabled()) {
                    logger.debug("use chache: page" + i + "-startRow = "
                            + cacheRow);
                }
                currentRow = cacheRow;
                currentPage = i;
                break;
            }
        }
        List<Community> communities = findCommunities(context, page,
                currentPage, currentRow);

        context.getFlashScope().put("communities", communities);
        context.getFlashScope().put("displayCount", DIAPLAY_COUNT);
        return success();
    }

    private List<Community> findCommunities(RequestContext context, int page,
            int curPage, int curRow) {
        int currentPage = curPage;
        int currentRow = curRow;
        List<Community> communities = new ArrayList<Community>(DIAPLAY_COUNT);
    outter:
        while (true) {
            List<Community> data = communityTable.findOrderByLastUpdateDateDesc(
                    currentRow, 10);
            if (data.isEmpty()) {
                // f[^Ȃ
                if (currentPage == page) {
                    // w肵y[W̑f[^s
                    break;
                } else {
                    // w肵y[WɓBĂȂɂւ炸f[^s
                    String message = "The page " + page + " not found.";
                    logger.warn(message);
                    throw new PageNotFoundException(context, this, message);
                }
            }
            for (Community c : data) {
                if (c.canRead(WebUtils.findUser(context))) {
                    // QƉ\ȃR~jeBǉ
                    communities.add(c);
                }
                currentRow++;
                if (communities.size() == DIAPLAY_COUNT) {
                    // f[^^
                    if (currentPage == page) {
                        // w肵y[W𑖍
                        break outter;
                    } else {
                        // ̃y[W
                        currentPage++;
                        context.getFlowScope().put(
                                "page" + currentPage + "-startRow", currentRow);
                        if (logger.isDebugEnabled()) {
                            logger.debug("set cache: page" + currentPage
                                    + "-startRow = " + currentRow);
                        }
                        communities.clear();
                    }
                }
            }
        }
        return communities;
    }
}
