package org.unitedfront2.web.controller.community;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.util.HtmlUtils;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.communication.AbstractCommunity;
import org.unitedfront2.domain.communication.Community;
import org.unitedfront2.domain.communication.CommunityTable;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.web.AccessDeniedException;
import org.unitedfront2.web.PageNotFoundException;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.view.RssView;

/**
 * R~jeB RSS zMpRg[łB
 *
 * @author kurokkie
 *
 */
@Repository(value = "communityCommunityRssController")
public class CommunityRssController extends AbstractController {

    /** R~jeBL̕\ (20) */
    public static final int DISPLAY_NUM = 20;

    /** ^Cg̍ő啶 */
    public static final int TITLE_MAX_SIZE = 64;

    /** R~jeBe[u */
    @Autowired
    private CommunityTable communityTable;

    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request,
            HttpServletResponse response) throws ServletRequestBindingException,
            PageNotFoundException, AccessDeniedException {
        String code = request.getParameter("code");
        User user = WebUtils.findUser(request.getSession(false));
        Community community;
        try {
            community = communityTable.findByCodeForRead(code, user);
        } catch (
                org.unitedfront2.domain.accesscontrol.AccessDeniedException e) {
            throw new AccessDeniedException(e);
        }
        return handleRequestInternal(request, community);
    }

    private ModelAndView handleRequestInternal(HttpServletRequest request,
            Community community) {
        Locale locale = WebUtils.getLocale(request);
        SyndFeed feed = new SyndFeedImpl();

        // Tv
        feed.setTitle(community.getOverview().getSubject(locale));
        feed.setLink("/community/" + community.getCode() + "/index.html");
        feed.setDescription(community.getOverview().getBody(locale));
        if (community instanceof AbstractCommunity) {
            AbstractCommunity c = (AbstractCommunity) community;
            feed.setAuthor(HtmlUtils.htmlEscape(c.getOwner().getName()));
        }

        // L
        List<Message> entries = Utils.findEntries(community, 0, DISPLAY_NUM);
        List<SyndEntry> sEntries = new ArrayList<SyndEntry>(entries.size());
        for (Message m : entries) {
            SyndEntry e = new SyndEntryImpl();
            e.setTitle(StringUtils.abbreviate(m.getBody(locale),
                    TITLE_MAX_SIZE));
            e.setLink(m.getUri());
            SyndContent description = new SyndContentImpl();
            description.setType("text/html");
            description.setValue(m.getBody(locale));
            e.setDescription(description);
            e.setPublishedDate(m.getRegistrationDate());
            e.setUpdatedDate(m.getLastUpdateDate());
            sEntries.add(e);
        }
        feed.setEntries(sEntries);

        ModelAndView mav = new ModelAndView(new RssView());
        mav.addObject(RssView.FEED_PARAM_NAME, feed);
        return mav;
    }
}
