package org.unitedfront2.web.controller.blog;

import java.util.Date;
import java.util.List;

import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.preparer.PreparerException;
import org.apache.tiles.preparer.ViewPreparer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.unitedfront2.domain.communication.Blog;
import org.unitedfront2.domain.communication.BlogTable;

/**
 * JuOEBWFbgp̃Rg[łB
 *
 * @author kurokkie
 *
 */
@Repository(value = "blogPublicBlogsWidgetPreparer")
public class PublicBlogsWidgetPreparer implements ViewPreparer {

    /** uOXgXVԊu (15) */
    public static final int REFLESH_TERM = 60 * 15 * 1000;

    /** ő\ (10) */
    public static final int MAX = 10;

    /** OXV */
    private Date lastRefleshDate;

    /** uOXg̃LbV */
    private List<Blog> cache;

    /** uOe[u */
    @Autowired private BlogTable blogTable;

    @Override
    public void execute(TilesRequestContext tilesContext,
            AttributeContext attributeContext) throws PreparerException {
        attributeContext.putAttribute("blogs", new Attribute(getBlogs()));
    }

    private List<Blog> getBlogs() {
        if (cache == null
                || new Date().after(new Date(lastRefleshDate.getTime()
                        + REFLESH_TERM))) {
            cache = blogTable.findPublicBlogsRandomly(MAX);
            lastRefleshDate = new Date();
        }
        return cache;
    }
}
